/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.tools.math.AverageVector;
import java.util.List;

public class Tools {
    @Deprecated
    public static void handleAverages(IOContainer evalOutput, List<AverageVector> averageVectors) throws OperatorException {
        Tools.handleAverages(evalOutput, averageVectors, true);
    }

    @Deprecated
    public static void handleAverages(IOContainer evalOutput, List<AverageVector> averageVectors, boolean onlyPerformanceVectors) throws OperatorException {
        Class<AverageVector> requestClass = AverageVector.class;
        if (onlyPerformanceVectors) {
            requestClass = PerformanceVector.class;
        }
        if (averageVectors.size() == 0) {
            boolean inputOk = true;
            while (inputOk) {
                try {
                    AverageVector currentAverage = evalOutput.remove(requestClass);
                    averageVectors.add(currentAverage);
                    for (int i = 0; i < currentAverage.getSize(); ++i) {
                        currentAverage.getAveragable(i).setAverageCount(0);
                    }
                }
                catch (MissingIOObjectException e) {
                    inputOk = false;
                }
            }
        } else {
            for (int n = 0; n < averageVectors.size(); ++n) {
                AverageVector currentAverage = evalOutput.remove(requestClass);
                AverageVector oldVector = averageVectors.get(n);
                if (!oldVector.getClass().isInstance(currentAverage)) {
                    throw new OperatorException("ValidationChain: Average vector mismatch! Fatal error.");
                }
                for (int i = 0; i < oldVector.size(); ++i) {
                    oldVector.getAveragable(i).buildAverage(currentAverage.getAveragable(i));
                }
            }
        }
    }

    @Deprecated
    public static PerformanceVector getPerformanceVector(List<AverageVector> averageVectors) {
        for (AverageVector currentAverage : averageVectors) {
            if (!(currentAverage instanceof PerformanceVector)) continue;
            return (PerformanceVector)currentAverage;
        }
        return null;
    }

    public static void buildAverages(PortPairExtender portExtender) throws OperatorException {
        for (PortPairExtender.PortPair pair : portExtender.getManagedPairs()) {
            Tools.buildAverages(pair.getInputPort(), pair.getOutputPort());
        }
    }

    public static void buildAverages(InputPort inputPort, OutputPort outputPort) throws OperatorException {
        AverageVector performance = (AverageVector)inputPort.getDataOrNull();
        if (performance == null) {
            return;
        }
        if (outputPort.getDataOrNull() == null) {
            for (int i = 0; i < performance.size(); ++i) {
                performance.getAveragable(i).setAverageCount(0);
            }
            outputPort.deliver(performance);
        } else {
            AverageVector average = (AverageVector)outputPort.getData();
            if (!average.getClass().isInstance(performance)) {
                throw new RuntimeException("Average vector mismatch!");
            }
            for (int i = 0; i < average.size(); ++i) {
                average.getAveragable(i).buildAverage(performance.getAveragable(i));
            }
            outputPort.deliver(average);
        }
    }
}

