/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.WrapperValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class RandomSplitWrapperValidationChain
extends WrapperValidationChain {
    public static final String PARAMETER_SPLIT_RATIO = "split_ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";

    public RandomSplitWrapperValidationChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        double splitRatio = this.getParameterAsDouble(PARAMETER_SPLIT_RATIO);
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        SplittedExampleSet eSet = new SplittedExampleSet(inputSet, splitRatio, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        eSet.selectSingleSubset(0);
        AttributeWeights weights = this.useWeightingMethod(eSet);
        SplittedExampleSet newInputSet = (SplittedExampleSet)eSet.clone();
        Model model = this.learn(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone());
        newInputSet.selectSingleSubset(1);
        PerformanceVector pv = this.evaluate(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone(), model);
        this.setResult(pv.getMainCriterion());
        this.performanceOutput.deliver(pv);
        this.attributeWeightsOutput.deliver(weights);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SPLIT_RATIO, "Relative size of the training set", 0.0, 1.0, 0.7);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

