/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class RandomSplitValidationChain
extends ValidationChain {
    public static final String PARAMETER_SPLIT_RATIO = "split_ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";

    public RandomSplitValidationChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public void estimatePerformance(ExampleSet inputSet) throws OperatorException {
        double splitRatio = this.getParameterAsDouble(PARAMETER_SPLIT_RATIO);
        SplittedExampleSet eSet = new SplittedExampleSet(inputSet, splitRatio, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        eSet.selectSingleSubset(0);
        this.learn(eSet);
        eSet.selectSingleSubset(1);
        this.evaluate(eSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SPLIT_RATIO, "Relative size of the training set", 0.0, 1.0, 0.7);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    protected MDInteger getTestSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return originalSize.multiply(1.0 - this.getParameterAsDouble(PARAMETER_SPLIT_RATIO));
    }

    @Override
    protected MDInteger getTrainingSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return originalSize.multiply(this.getParameterAsDouble(PARAMETER_SPLIT_RATIO));
    }
}

