/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.AverageVector;
import java.util.List;

public class IteratingPerformanceAverage
extends OperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    private PerformanceCriterion lastPerformance;
    private PortPairExtender inExtender = new PortPairExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private final PortPairExtender performancePortExtender = new PortPairExtender("averagable", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts(), new MetaData(AverageVector.class));

    public IteratingPerformanceAverage(OperatorDescription description) {
        super(description, "Subprocess");
        this.inExtender.start();
        this.performancePortExtender.start();
        this.getTransformer().addRule(this.inExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.performancePortExtender.makePassThroughRule());
        this.addValue(new ValueDouble("performance", "The last performance average (main criterion)."){

            @Override
            public double getDoubleValue() {
                if (IteratingPerformanceAverage.this.lastPerformance != null) {
                    return IteratingPerformanceAverage.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        int numberOfIterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        for (int i = 0; i < numberOfIterations; ++i) {
            this.evaluate();
            this.inApplyLoop();
        }
        boolean success = false;
        for (IOObject result : this.performancePortExtender.getData()) {
            if (!(result instanceof PerformanceVector)) continue;
            this.lastPerformance = ((PerformanceVector)result).getMainCriterion();
            success = true;
        }
        if (!success) {
            this.lastPerformance = null;
            this.getLogger().warning("No performance vector found among averagable results. Performance will not be loggable.");
        }
    }

    private void evaluate() throws OperatorException {
        this.inExtender.passCloneThrough();
        this.getSubprocess(0).execute();
        Tools.buildAverages(this.performancePortExtender);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        return types;
    }
}

