/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class BatchXValidation
extends ValidationChain {
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    private int iteration;

    public BatchXValidation(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            @Override
            public double getDoubleValue() {
                return BatchXValidation.this.iteration;
            }
        });
    }

    @Override
    public void estimatePerformance(ExampleSet inputSet) throws OperatorException {
        Attribute batchAttribute = inputSet.getAttributes().getSpecial("batch");
        if (batchAttribute == null) {
            throw new UserError((Operator)this, 113, "batch");
        }
        SplittedExampleSet splittedES = SplittedExampleSet.splitByAttribute(inputSet, batchAttribute);
        this.iteration = 0;
        while (this.iteration < splittedES.getNumberOfSubsets()) {
            splittedES.selectAllSubsetsBut(this.iteration);
            this.learn(splittedES);
            splittedES.selectSingleSubset(this.iteration);
            this.evaluate(splittedES);
            this.inApplyLoop();
            ++this.iteration;
        }
    }

    @Override
    protected MDInteger getTestSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return new MDInteger();
    }

    @Override
    protected MDInteger getTrainingSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return new MDInteger();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors", true));
        return types;
    }
}

