/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

public abstract class AbstractBootstrappingValidation
extends ValidationChain {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    private int number;
    private int iteration;

    public AbstractBootstrappingValidation(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            @Override
            public double getDoubleValue() {
                return AbstractBootstrappingValidation.this.iteration;
            }
        });
    }

    protected abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public void estimatePerformance(ExampleSet inputSet) throws OperatorException {
        this.number = this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        this.iteration = 0;
        while (this.iteration < this.number) {
            int[] mapping = this.createMapping(inputSet, (int)Math.round((double)inputSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO)), random);
            MappedExampleSet trainingSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, true);
            this.learn(trainingSet);
            MappedExampleSet inverseExampleSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, false);
            this.evaluate(inverseExampleSet);
            this.inApplyLoop();
            ++this.iteration;
        }
    }

    @Override
    protected MDInteger getTestSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return originalSize.multiply(1.0 - this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
    }

    @Override
    protected MDInteger getTrainingSetSize(MDInteger originalSize) throws UndefinedParameterError {
        return originalSize.multiply(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "This ratio of examples will be sampled (with replacement) in each iteration.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

