/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.MailUtilities;
import java.util.HashMap;
import java.util.List;

public class SendMailOperator
extends Operator {
    private DummyPortPairExtender through = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());
    public static final String PARAMETER_TO = "to";
    public static final String PARAMETER_SUBJECT = "subject";
    public static final String PARAMETER_BODY_PLAIN = "body_plain";
    public static final String PARAMETER_BODY_HTML = "body_html";
    public static final String PARAMETER_USE_HTML = "use_html";
    public static final String PARAMETER_HEADERS = "headers";

    public SendMailOperator(OperatorDescription description) {
        super(description);
        this.through.start();
        this.getTransformer().addRule(this.through.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        String body;
        String to = this.getParameterAsString(PARAMETER_TO);
        String subject = this.getParameterAsString(PARAMETER_SUBJECT);
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String[] entry : this.getParameterList(PARAMETER_HEADERS)) {
            headers.put(entry[0], entry[1]);
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_HTML)) {
            body = this.getParameterAsString(PARAMETER_BODY_HTML);
            headers.put("Content-Type", "text/html");
        } else {
            body = this.getParameterAsString(PARAMETER_BODY_PLAIN);
        }
        MailUtilities.sendEmail(to, subject, body, headers);
        this.through.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_TO, "Receiver of the email.", false, false));
        types.add(new ParameterTypeString(PARAMETER_SUBJECT, "Subject the email.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_HTML, "Format text as HTML?.", false, false));
        ParameterType type = new ParameterTypeText(PARAMETER_BODY_PLAIN, "Body of the email.", TextType.PLAIN, false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_HTML, false, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeText(PARAMETER_BODY_HTML, "Body of the email in HTML format.", TextType.HTML, "<html>\n\t<head>\n\t\t<title>RapidMiner Mail Message</title>\n\t</head>\n\t<body>\n\t\t<p>\n\t\t</p>\n\t</body>\n</html>\n");
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_HTML, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_HEADERS, "Additional mail headers", (ParameterType)new ParameterTypeString("header", "Name of the header"), (ParameterType)new ParameterTypeString("value", "value of the header"));
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

