/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.tools.SerializationType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class IOObjectSerializer {
    public static final byte[] MAGIC_NUMBER = new byte[]{42, 113, -47};
    private static final IOObjectSerializer INSTANCE = new IOObjectSerializer();

    public static IOObjectSerializer getInstance() {
        return INSTANCE;
    }

    public void serialize(OutputStream out, Object object) throws IOException {
        SerializationType type = object instanceof ExampleSet ? SerializationType.STREAMED_EXAMPLE_SET_DENSE_CURRENT_VERSION : SerializationType.JAVA_BINARY;
        this.serialize(out, object, type);
    }

    public void writeHeader(OutputStream out, SerializationType serializationType) throws IOException {
        out.write(MAGIC_NUMBER);
        out.flush();
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(serializationType.ordinal());
        dout.flush();
    }

    public void serialize(OutputStream out, Object object, SerializationType serializationType) throws IOException {
        this.writeHeader(out, serializationType);
        serializationType.getBodySerializer().serialize(object, out);
        out.flush();
    }

    public SerializationType deserializeHeader(InputStream in) throws IOException {
        int length;
        byte[] magicRead = new byte[MAGIC_NUMBER.length];
        int offset = 0;
        do {
            if ((length = in.read(magicRead, offset, MAGIC_NUMBER.length - offset)) != -1) continue;
            throw new IOException("EOF while reading magic number.");
        } while ((offset += length) < MAGIC_NUMBER.length);
        if (!Arrays.equals(magicRead, MAGIC_NUMBER)) {
            throw new IOException("No magic number found. Make sure you are using RapidMiner 5.0 compatible files.");
        }
        DataInputStream din = new DataInputStream(in);
        int typeIndex = din.readInt();
        if (typeIndex < 0 || typeIndex > SerializationType.values().length) {
            throw new IOException("Illegal serialization type: " + typeIndex);
        }
        return SerializationType.values()[typeIndex];
    }

    public Object deserialize(InputStream in) throws IOException {
        SerializationType type = this.deserializeHeader(in);
        return type.getBodySerializer().deserialize(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeToBuffer(Object o) throws IOException {
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        try {
            this.serialize(bufOut, o);
            bufOut.flush();
            byte[] byArray = bufOut.toByteArray();
            return byArray;
        }
        finally {
            bufOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeFromBuffer(byte[] buffer) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bufIn = new ByteArrayInputStream(buffer);
        try {
            Object object = this.deserialize(bufIn);
            return object;
        }
        finally {
            bufIn.close();
        }
    }
}

