/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.example.table.SparseDataRow;
import com.rapidminer.operator.Annotations;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetToStream {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int CURRENT_VERSION = 3;
    private static final Charset STRING_CHARSET = Charset.forName("UTF-8");
    private int version;

    public ExampleSetToStream(int version) {
        this.version = version;
        if (version != 3) {
            LogService.getRoot().warning("Using deprecated example set stream version " + version);
        }
    }

    public void write(ExampleSet exampleSet, OutputStream outputStream) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        LinkedList<AttributeRole> allRoles = new LinkedList<AttributeRole>();
        Iterator<AttributeRole> i = exampleSet.getAttributes().allAttributeRoles();
        while (i.hasNext()) {
            allRoles.add(i.next());
        }
        boolean sparse = false;
        if (exampleSet.size() > 0 && exampleSet.getExample(0).getDataRow() instanceof SparseDataRow) {
            sparse = true;
        }
        this.writeHeader(exampleSet.getAnnotations(), allRoles, out, sparse);
        this.writeData(exampleSet, out, allRoles, sparse);
        out.flush();
    }

    private void writeData(ExampleSet exampleSet, DataOutputStream out, List<AttributeRole> allRoles, boolean sparse) throws IOException {
        out.writeInt(exampleSet.size());
        ColumnType[] columnTypes = this.convertToColumnTypes(allRoles);
        for (Example example : exampleSet) {
            int attributeIndex = 0;
            for (AttributeRole role : allRoles) {
                Attribute attribute = role.getAttribute();
                double value = example.getValue(attribute);
                this.writeDatum(value, attributeIndex, attribute, columnTypes[attributeIndex], out, sparse);
                ++attributeIndex;
            }
            if (!sparse) continue;
            out.writeInt(-1);
        }
    }

    public void writeHeader(Annotations annotations, List<AttributeRole> allAttributes, DataOutputStream out, boolean sparse) throws IOException {
        this.writeAnnotations(out, annotations);
        out.writeInt(allAttributes.size());
        for (AttributeRole role : allAttributes) {
            Attribute att = role.getAttribute();
            this.writeString(out, att.getName());
            String specialName = role.getSpecialName();
            if (specialName != null) {
                this.writeString(out, specialName);
            } else {
                this.writeString(out, "");
            }
            this.writeString(out, Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(att.getValueType()));
            this.writeString(out, Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(att.getBlockType()));
            if (att.isNominal()) {
                NominalMapping mapping = att.getMapping();
                out.writeInt(mapping.size());
                for (String value : mapping.getValues()) {
                    out.writeInt(mapping.mapString(value));
                    this.writeString(out, value);
                }
            }
            this.writeAnnotations(out, att.getAnnotations());
        }
        out.writeBoolean(sparse);
        if (sparse) {
            for (AttributeRole role : allAttributes) {
                out.writeDouble(role.getAttribute().getDefault());
            }
        }
    }

    public ExampleSet read(InputStream inputStream) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        Header header = this.readHeader(in);
        List<AttributeRole> allAttributeRoles = header.getAllRoles();
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        for (AttributeRole role : allAttributeRoles) {
            allAttributes.add(role.getAttribute());
        }
        ColumnType[] columnTypes = this.convertToColumnTypes(allAttributeRoles);
        boolean sparse = header.isSparse();
        MemoryExampleTable exampleTable = new MemoryExampleTable(allAttributes);
        int size = in.readInt();
        for (int row = 0; row < size; ++row) {
            if (sparse) {
                int index;
                DoubleSparseArrayDataRow sparseRow = new DoubleSparseArrayDataRow(allAttributeRoles.size());
                while ((index = in.readInt()) != -1) {
                    sparseRow.set((Attribute)allAttributes.get(index), this.readDatum(in, columnTypes[index]));
                }
                sparseRow.trim();
                exampleTable.addDataRow(sparseRow);
                continue;
            }
            double[] data = new double[allAttributeRoles.size()];
            this.readRow(in, data, columnTypes, sparse);
            exampleTable.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet exampleSet = exampleTable.createExampleSet();
        for (AttributeRole role : allAttributeRoles) {
            if (!role.isSpecial()) continue;
            Attribute att = exampleSet.getAttributes().get(role.getAttribute().getName());
            exampleSet.getAttributes().getRole(att).setSpecial(role.getSpecialName());
        }
        exampleSet.getAnnotations().putAll(header.getAnnotations());
        return exampleSet;
    }

    public Header readHeader(DataInputStream in) throws IOException {
        Annotations annotations = this.readAnnotations(in);
        int numAttributes = in.readInt();
        LinkedList<AttributeRole> allRoles = new LinkedList<AttributeRole>();
        for (int i = 0; i < numAttributes; ++i) {
            String tmp;
            int valueType;
            String name = this.readString(in);
            String special = this.readString(in);
            if (special.length() == 0) {
                special = null;
            }
            if ((valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(tmp = this.readString(in))) == -1) {
                throw new IOException("Unknown value type: '" + tmp + "'");
            }
            tmp = this.readString(in);
            int blockType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(tmp);
            if (blockType == -1) {
                throw new IOException("Unknown value type: '" + tmp + "'");
            }
            Attribute attribute = AttributeFactory.createAttribute(name, valueType, blockType);
            AttributeRole role = new AttributeRole(attribute);
            if (special != null) {
                role.setSpecial(special);
            }
            allRoles.add(role);
            if (attribute.isNominal()) {
                String value;
                int index;
                int j;
                int numValues = in.readInt();
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 6)) {
                    NominalMapping mapping = attribute.getMapping();
                    for (j = 0; j < numValues; ++j) {
                        index = in.readInt();
                        value = this.readString(in);
                        mapping.setMapping(value, index);
                    }
                } else {
                    HashMap<Integer, String> valueMap = new HashMap<Integer, String>();
                    for (j = 0; j < numValues; ++j) {
                        index = in.readInt();
                        value = this.readString(in);
                        valueMap.put(index, value);
                    }
                    attribute.setMapping(new PolynominalMapping(valueMap));
                }
            }
            Annotations attAnnotations = this.readAnnotations(in);
            attribute.getAnnotations().putAll(attAnnotations);
        }
        boolean sparse = in.readBoolean();
        if (sparse) {
            for (AttributeRole role : allRoles) {
                role.getAttribute().setDefault(in.readDouble());
            }
        }
        return new Header(annotations, allRoles, sparse);
    }

    public ColumnType[] convertToColumnTypes(List<AttributeRole> allRoles) {
        ColumnType[] columnTypes = new ColumnType[allRoles.size()];
        for (int i = 0; i < columnTypes.length; ++i) {
            Attribute att = allRoles.get(i).getAttribute();
            if (att.isNominal()) {
                if (att.getMapping().size() < 127) {
                    columnTypes[i] = ColumnType.NOMINAL_BYTE;
                    continue;
                }
                if (att.getMapping().size() < Short.MAX_VALUE) {
                    columnTypes[i] = ColumnType.NOMINAL_SHORT;
                    continue;
                }
                columnTypes[i] = ColumnType.NOMINAL_INTEGER;
                continue;
            }
            if (att.isNumerical()) {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 3)) {
                    columnTypes[i] = ColumnType.INTEGER;
                    continue;
                }
                columnTypes[i] = ColumnType.DOUBLE;
                continue;
            }
            columnTypes[i] = ColumnType.DOUBLE;
        }
        return columnTypes;
    }

    public final void writeDatum(double value, int attributeIndex, Attribute attribute, ColumnType columnType, DataOutput out, boolean sparse) throws IOException {
        if (sparse) {
            if (Tools.isDefault(attribute.getDefault(), value)) {
                return;
            }
            out.writeInt(attributeIndex);
        }
        switch (columnType) {
            case DOUBLE: {
                out.writeDouble(value);
                break;
            }
            case INTEGER: {
                if (Double.isNaN(value)) {
                    out.writeInt(-2147483647);
                    out.writeBoolean(true);
                    break;
                }
                out.writeInt((int)value);
                if ((int)value != -2147483647) break;
                out.writeBoolean(false);
                break;
            }
            case NOMINAL_BYTE: {
                if (Double.isNaN(value)) {
                    out.writeByte(-1);
                    break;
                }
                out.writeByte((byte)value);
                break;
            }
            case NOMINAL_INTEGER: {
                if (Double.isNaN(value)) {
                    out.writeInt(-1);
                    break;
                }
                out.writeInt((int)value);
                break;
            }
            case NOMINAL_SHORT: {
                if (Double.isNaN(value)) {
                    out.writeShort(-1);
                    break;
                }
                out.writeShort((short)value);
                break;
            }
            default: {
                throw new RuntimeException("Illegal type: " + (Object)((Object)columnType));
            }
        }
    }

    private final double readDatum(DataInput in, ColumnType columnType) throws IOException {
        switch (columnType) {
            case DOUBLE: {
                return in.readDouble();
            }
            case INTEGER: {
                int iValue = in.readInt();
                if (iValue == -2147483647) {
                    boolean isMissing = in.readBoolean();
                    if (isMissing) {
                        return Double.NaN;
                    }
                    return iValue;
                }
                return iValue;
            }
            case NOMINAL_BYTE: {
                byte bValue = in.readByte();
                if (bValue == -1) {
                    return Double.NaN;
                }
                return bValue;
            }
            case NOMINAL_INTEGER: {
                int iValue = in.readInt();
                if (iValue == -1) {
                    return Double.NaN;
                }
                return iValue;
            }
            case NOMINAL_SHORT: {
                short sValue = in.readShort();
                if (sValue == -1) {
                    return Double.NaN;
                }
                return sValue;
            }
        }
        throw new RuntimeException("Illegal type: " + (Object)((Object)columnType));
    }

    public void readRow(DataInputStream in, double[] data, ColumnType[] columnTypes, boolean sparse) throws IOException {
        if (sparse) {
            int index;
            while ((index = in.readInt()) != -1) {
                data[index] = this.readDatum(in, columnTypes[index]);
            }
        } else {
            for (int attIndex = 0; attIndex < columnTypes.length; ++attIndex) {
                data[attIndex] = this.readDatum(in, columnTypes[attIndex]);
            }
        }
    }

    private void writeString(DataOutput out, String value) throws IOException {
        switch (this.version) {
            case 1: {
                out.writeUTF(value);
                break;
            }
            case 2: 
            case 3: {
                byte[] bytes = value.getBytes(STRING_CHARSET);
                out.writeInt(bytes.length);
                out.write(bytes);
                break;
            }
            default: {
                throw new RuntimeException("Version not set");
            }
        }
    }

    private String readString(DataInput in) throws IOException {
        switch (this.version) {
            case 1: {
                return in.readUTF();
            }
            case 2: 
            case 3: {
                int length = in.readInt();
                byte[] bytes = new byte[length];
                in.readFully(bytes);
                return new String(bytes, STRING_CHARSET);
            }
        }
        throw new RuntimeException("Version not set");
    }

    public int getVersion() {
        return this.version;
    }

    public void writeAnnotations(DataOutput out, Annotations annotations) throws IOException {
        if (this.version < 3) {
            LogService.getRoot().warning("Ignoring annotations in example set stream version " + this.version);
        } else if (annotations == null) {
            out.writeInt(0);
        } else {
            out.writeInt(annotations.size());
            for (String key : annotations.getKeys()) {
                this.writeString(out, key);
                this.writeString(out, annotations.getAnnotation(key));
            }
        }
    }

    public Annotations readAnnotations(DataInput in) throws IOException {
        if (this.version < 3) {
            return new Annotations();
        }
        Annotations result = new Annotations();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            result.setAnnotation(this.readString(in), this.readString(in));
        }
        return result;
    }

    public static class Header {
        private final Annotations annotations;
        private final List<AttributeRole> allRoles;
        private final boolean sparse;

        protected Header(Annotations annotations, List<AttributeRole> allRoles, boolean sparse) {
            this.allRoles = allRoles;
            this.sparse = sparse;
            this.annotations = annotations;
        }

        public List<AttributeRole> getAllRoles() {
            return this.allRoles;
        }

        public boolean isSparse() {
            return this.sparse;
        }

        public Annotations getAnnotations() {
            return this.annotations;
        }
    }

    public static enum ColumnType {
        NOMINAL_BYTE,
        NOMINAL_SHORT,
        NOMINAL_INTEGER,
        DOUBLE,
        INTEGER;

    }
}

