/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class DelayOperator
extends Operator {
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public DelayOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        DelayProvider.createDelayProvider(this).delay();
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        return DelayProvider.getParameterTypes(this);
    }

    public static class DelayProvider {
        public static final String PARAMETER_DELAY = "delay";
        public static final String[] DELAY_MODES = new String[]{"none", "fixed", "random"};
        public static final int DELAY_NONE = 0;
        public static final int DELAY_FIXED = 1;
        public static final int DELAY_RANDOM = 2;
        public static final String PARAMETER_DELAY_AMOUNT = "delay_amount";
        public static final String PARAMETER_DELAY_MIN_AMOUNT = "min_delay_amount";
        public static final String PARAMETER_DELAY_MAX_AMOUNT = "max_delay_amount";
        private int minAmount = 0;
        private int maxAmount = 1000;
        private RandomGenerator randomGenerator = null;

        private DelayProvider(int mode, int amount, int minAmount, int maxAmount) {
            switch (mode) {
                case 0: {
                    this.minAmount = 0;
                    this.maxAmount = 0;
                    break;
                }
                case 1: {
                    this.minAmount = amount;
                    this.maxAmount = amount;
                    break;
                }
                case 2: {
                    this.minAmount = minAmount;
                    this.maxAmount = maxAmount;
                    this.randomGenerator = RandomGenerator.getGlobalRandomGenerator();
                }
            }
        }

        public void delay() {
            try {
                if (this.minAmount == this.maxAmount) {
                    Thread.sleep(this.maxAmount);
                } else {
                    Thread.sleep(this.randomGenerator.nextIntInRange(this.minAmount, this.maxAmount));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public static DelayProvider createDelayProvider(ParameterHandler handler) throws UndefinedParameterError {
            return new DelayProvider(handler.getParameterAsInt(PARAMETER_DELAY), handler.getParameterAsInt(PARAMETER_DELAY_AMOUNT), handler.getParameterAsInt(PARAMETER_DELAY_MIN_AMOUNT), handler.getParameterAsInt(PARAMETER_DELAY_MAX_AMOUNT));
        }

        public static List<ParameterType> getParameterTypes(ParameterHandler handler) {
            LinkedList<ParameterType> types = new LinkedList<ParameterType>();
            types.add(new ParameterTypeCategory(PARAMETER_DELAY, "Specifies whether execution should not be delayed, delayed by a fixed or random amount of time.", DELAY_MODES, 0, false));
            ParameterTypeInt type = new ParameterTypeInt(PARAMETER_DELAY_AMOUNT, "The delay amount in ms.", 0, Integer.MAX_VALUE, 1000, false);
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DELAY, DELAY_MODES, true, 1));
            types.add(type);
            type = new ParameterTypeInt(PARAMETER_DELAY_MIN_AMOUNT, "The minimum delay amount in ms.", 0, Integer.MAX_VALUE, 0, false);
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DELAY, DELAY_MODES, true, 2));
            types.add(type);
            type = new ParameterTypeInt(PARAMETER_DELAY_MAX_AMOUNT, "The maximum delay amount in ms.", 0, Integer.MAX_VALUE, 1000, false);
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DELAY, DELAY_MODES, true, 2));
            types.add(type);
            return types;
        }
    }
}

