/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.BlockTypeAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NoMissingValuesAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NumericValueAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.RegexpAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.SingleAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.SubsetAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.TransparentAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.ValueTypeAttributeFilter;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.Ontology;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AttributeSubsetSelector {
    public static final String PARAMETER_FILTER_TYPE = "attribute_filter_type";
    public static final String PARAMETER_INVERT_SELECTION = "invert_selection";
    public static final String PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES = "include_special_attributes";
    public static String[] CONDITION_NAMES = new String[]{"all", "single", "subset", "regular_expression", "value_type", "block_type", "no_missing_values", "numeric_value_filter"};
    private static Class[] CONDITION_IMPLEMENTATIONS = new Class[]{TransparentAttributeFilter.class, SingleAttributeFilter.class, SubsetAttributeFilter.class, RegexpAttributeFilter.class, ValueTypeAttributeFilter.class, BlockTypeAttributeFilter.class, NoMissingValuesAttributeFilter.class, NumericValueAttributeFilter.class};
    public static final int CONDITION_ALL = 0;
    public static final int CONDITION_SINGLE = 1;
    public static final int CONDITION_SUBSET = 2;
    public static final int CONDITION_REGULAR_EXPRESSION = 3;
    public static final int CONDITION_VALUE_TYPE = 5;
    public static final int CONDITION_BLOCK_TYPE = 6;
    public static final int CONDITION_NO_MISSING_VALUES = 7;
    public static final int CONDITION_NUMERIC_VALUE_FILTER = 8;
    private final ParameterHandler operator;
    private final InputPort inPort;
    private int[] valueTypes;

    public AttributeSubsetSelector(ParameterHandler operator, InputPort inPort) {
        this(operator, inPort, 0);
    }

    public AttributeSubsetSelector(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        this.operator = operator;
        this.inPort = inPort;
        this.valueTypes = valueTypes.length == 0 ? new int[]{0} : valueTypes;
    }

    public ExampleSetMetaData getMetaDataSubset(ExampleSetMetaData metaData, boolean keepSpecialIfNotIncluded) {
        try {
            Collection<AttributeMetaData> attributes = metaData.getAllAttributes();
            AttributeFilterCondition condition = AttributeSubsetSelector.createCondition(CONDITION_NAMES[this.operator.getParameterAsInt(PARAMETER_FILTER_TYPE)], this.operator);
            ExampleSetMetaData resultSet = metaData.clone();
            boolean invert = this.operator.getParameterAsBoolean(PARAMETER_INVERT_SELECTION);
            boolean applyOnSpecial = this.operator.getParameterAsBoolean(PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES);
            boolean foundUnkown = false;
            for (AttributeMetaData attribute : attributes) {
                if (!attribute.isSpecial() || attribute.isSpecial() && applyOnSpecial) {
                    MetaDataInfo result = condition.isFilteredOutMetaData(attribute, this.operator);
                    if (invert) {
                        if (result == MetaDataInfo.NO) {
                            result = MetaDataInfo.YES;
                        } else if (result == MetaDataInfo.YES) {
                            result = MetaDataInfo.NO;
                        }
                    }
                    if (result == MetaDataInfo.YES) {
                        resultSet.removeAttribute(attribute);
                    }
                    if (result != MetaDataInfo.UNKNOWN) continue;
                    foundUnkown = true;
                    continue;
                }
                if (keepSpecialIfNotIncluded) continue;
                resultSet.removeAttribute(attribute);
            }
            if (applyOnSpecial) {
                for (AttributeMetaData attribute : resultSet.getAllAttributes()) {
                    attribute.setRegular();
                }
            }
            Iterator<AttributeMetaData> iterator = resultSet.getAllAttributes().iterator();
            while (iterator.hasNext()) {
                boolean keep;
                AttributeMetaData attribute;
                attribute = iterator.next();
                if (attribute.isSpecial() || (keep = this.isOfAllowedType(attribute.getValueType()))) continue;
                iterator.remove();
            }
            if (foundUnkown) {
                resultSet.attributesAreSubset();
            }
            switch (metaData.getAttributeSetRelation()) {
                case SUBSET: {
                    resultSet.attributesAreSubset();
                    break;
                }
                case SUPERSET: {
                    resultSet.attributesAreSuperset();
                }
            }
            return resultSet;
        }
        catch (ConditionCreationException e) {
            return new ExampleSetMetaData();
        }
        catch (UndefinedParameterError e) {
            return new ExampleSetMetaData();
        }
    }

    private boolean isOfAllowedType(int attributeValueType) {
        boolean keep = false;
        for (int type : this.valueTypes) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeValueType, type)) continue;
            keep = true;
            break;
        }
        return keep;
    }

    public ExampleSet getSubset(ExampleSet parent, boolean keepSpecialIfNotIncluded) throws UndefinedParameterError, UserError {
        boolean includeSpecial = this.operator.getParameterAsBoolean(PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES);
        ExampleSet clone = (ExampleSet)parent.clone();
        Set<Attribute> attributeSubset = this.getAttributeSubset(clone, keepSpecialIfNotIncluded);
        Iterator<Attribute> iterator = clone.getAttributes().allAttributes();
        while (iterator.hasNext()) {
            AttributeRole currentRole;
            Attribute currentAttribute = iterator.next();
            if (!attributeSubset.contains(currentAttribute)) {
                iterator.remove();
                continue;
            }
            if (!includeSpecial || !(currentRole = clone.getAttributes().getRole(currentAttribute)).isSpecial()) continue;
            currentRole.changeToRegular();
        }
        return clone;
    }

    public Set<Attribute> getAttributeSubset(ExampleSet exampleSet, boolean keepSpecialIfNotIncluded) throws UndefinedParameterError, UserError {
        try {
            Attributes attributes = exampleSet.getAttributes();
            AttributeFilterCondition condition = AttributeSubsetSelector.createCondition(CONDITION_NAMES[this.operator.getParameterAsInt(PARAMETER_FILTER_TYPE)], this.operator);
            boolean invert = this.operator.getParameterAsBoolean(PARAMETER_INVERT_SELECTION);
            LinkedHashSet<Attribute> remainingAttributes = new LinkedHashSet<Attribute>();
            Iterator<Attribute> iterator = null;
            iterator = this.operator.getParameterAsBoolean(PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES) ? attributes.allAttributes() : attributes.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (!this.isOfAllowedType(attribute.getValueType())) continue;
                AttributeFilterCondition.ScanResult result = condition.beforeScanCheck(attribute).invert(invert);
                switch (result) {
                    case KEEP: 
                    case UNCHECKED: {
                        remainingAttributes.add(attribute);
                    }
                }
            }
            if (condition.isNeedingScan()) {
                for (Attribute attribute : remainingAttributes) {
                    AttributeFilterCondition.ScanResult afterScanResult = AttributeFilterCondition.ScanResult.UNCHECKED;
                    for (Example example : exampleSet) {
                        AttributeFilterCondition.ScanResult result = condition.check(attribute, example);
                        if (result == AttributeFilterCondition.ScanResult.UNCHECKED) continue;
                        afterScanResult = result;
                        break;
                    }
                    if (condition.isNeedingFullScan()) {
                        afterScanResult = condition.checkAfterFullScan();
                    } else if (afterScanResult == AttributeFilterCondition.ScanResult.UNCHECKED) {
                        afterScanResult = AttributeFilterCondition.ScanResult.KEEP;
                    }
                    if ((afterScanResult = afterScanResult.invert(invert)) != AttributeFilterCondition.ScanResult.REMOVE) continue;
                    attributes.remove(attribute);
                }
            }
            if (keepSpecialIfNotIncluded && !this.operator.getParameterAsBoolean(PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES)) {
                Iterator<AttributeRole> roleIterator = attributes.allAttributeRoles();
                while (roleIterator.hasNext()) {
                    AttributeRole currentRole = roleIterator.next();
                    if (!currentRole.isSpecial()) continue;
                    remainingAttributes.add(currentRole.getAttribute());
                }
            }
            return remainingAttributes;
        }
        catch (ConditionCreationException e) {
            if (this.operator instanceof Operator) {
                throw new UserError((Operator)this.operator, (Throwable)e, 904, CONDITION_NAMES[this.operator.getParameterAsInt(PARAMETER_FILTER_TYPE)], e.getMessage());
            }
            throw new UserError(null, (Throwable)e, 904, new Object[]{CONDITION_NAMES[this.operator.getParameterAsInt(PARAMETER_FILTER_TYPE)], e.getMessage()});
        }
    }

    public static AttributeFilterCondition createCondition(String name, ParameterHandler operator) throws ConditionCreationException {
        try {
            for (int i = 0; i < CONDITION_NAMES.length; ++i) {
                if (!CONDITION_NAMES[i].equals(name)) continue;
                AttributeFilterCondition condition = (AttributeFilterCondition)CONDITION_IMPLEMENTATIONS[i].newInstance();
                condition.init(operator);
                return condition;
            }
            throw new ConditionCreationException("Cannot find class '" + name + "'. Check your classpath.");
        }
        catch (IllegalAccessException e) {
            throw new ConditionCreationException("'" + name + "' cannot access two argument constructor " + name + "(ExampleSet, String)!", e);
        }
        catch (InstantiationException e) {
            throw new ConditionCreationException(name + ": cannot create condition (" + e.getMessage() + ").", e);
        }
        catch (Throwable e) {
            throw new ConditionCreationException(name + ": cannot create condition (" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + ").", e);
        }
    }

    public static void registerCondition(String conditionName, Class<? extends AttributeFilterCondition> conditionClass) {
        String[] newConditionNames = new String[CONDITION_NAMES.length + 1];
        System.arraycopy(CONDITION_NAMES, 0, newConditionNames, 0, CONDITION_NAMES.length);
        newConditionNames[newConditionNames.length - 1] = conditionName;
        CONDITION_NAMES = newConditionNames;
        Class[] newConditionClasses = new Class[CONDITION_IMPLEMENTATIONS.length + 1];
        System.arraycopy(CONDITION_IMPLEMENTATIONS, 0, newConditionClasses, 0, CONDITION_IMPLEMENTATIONS.length);
        newConditionClasses[newConditionClasses.length - 1] = conditionClass;
        CONDITION_IMPLEMENTATIONS = newConditionClasses;
    }

    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_FILTER_TYPE, "The condition specifies which attributes are selected or affected by this operator.", CONDITION_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        for (int i = 0; i < CONDITION_IMPLEMENTATIONS.length; ++i) {
            try {
                List<ParameterType> filterConditions = ((AttributeFilterCondition)CONDITION_IMPLEMENTATIONS[i].newInstance()).getParameterTypes(this.operator, this.inPort, this.valueTypes);
                for (ParameterType conditionalType : filterConditions) {
                    types.add(conditionalType);
                    conditionalType.registerDependencyCondition(new EqualTypeCondition(this.operator, PARAMETER_FILTER_TYPE, CONDITION_NAMES, !conditionalType.isExpert(), i));
                }
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        type = new ParameterTypeBoolean(PARAMETER_INVERT_SELECTION, "Indicates if only attributes should be accepted which would normally filtered.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INCLUDE_SPECIAL_ATTRIBUTES, "Indicate if this operator should also be applied on the special attributes. Otherwise they are always kept.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    public Precondition makePrecondition() {
        return new Precondition(){

            @Override
            public void assumeSatisfied() {
            }

            @Override
            public void check(MetaData metaData) {
                ExampleSetMetaData subsetMetaData;
                if (metaData instanceof ExampleSetMetaData && (subsetMetaData = AttributeSubsetSelector.this.getMetaDataSubset((ExampleSetMetaData)metaData, false)).getAllAttributes().isEmpty()) {
                    AbstractQuickFix selectAllQuickFix = new AbstractQuickFix(4, false, "attributefilter_select_all", new Object[0]){

                        @Override
                        public void apply() {
                            AttributeSubsetSelector.this.operator.getParameters().setParameter(AttributeSubsetSelector.PARAMETER_FILTER_TYPE, CONDITION_NAMES[0]);
                        }
                    };
                    SimpleMetaDataError error = new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)AttributeSubsetSelector.this.inPort, Collections.singletonList(selectAllQuickFix), "attribute_selection_empty", new Object[0]);
                    AttributeSubsetSelector.this.inPort.addError(error);
                }
            }

            @Override
            public String getDescription() {
                return "Example set matching at least one selected attribute.";
            }

            @Override
            public MetaData getExpectedMetaData() {
                return new ExampleSetMetaData();
            }

            @Override
            public boolean isCompatible(MetaData input, CompatibilityLevel level) {
                return ExampleSet.class.isAssignableFrom(input.getObjectClass());
            }
        };
    }
}

