/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.similarity;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.similarity.SimilarityMeasureObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.container.Range;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.ArrayList;
import java.util.List;

public class Similarity2ExampleSet
extends Operator {
    private final InputPort similarityInput = this.getInputPorts().createPort("similarity", SimilarityMeasureObject.class);
    private final InputPort exampleSetInput = this.getInputPorts().createPort("exampleSet", ExampleSet.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exampleSet");
    public static final String PARAMETER_TABLE_TYPE = "table_type";
    public static final String[] TABLE_TYPES = new String[]{"long_table", "matrix"};
    public static final int TABLE_TYPE_LONG_TABLE = 0;
    public static final int TABLE_TYPE_MATRIX = 1;

    public Similarity2ExampleSet(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                AttributeMetaData idAttribute = metaData.getSpecial("id");
                try {
                    if (Similarity2ExampleSet.this.getParameterAsInt(Similarity2ExampleSet.PARAMETER_TABLE_TYPE) == 0) {
                        if (idAttribute == null) {
                            MetaDataTools.checkAndCreateIds(metaData);
                        }
                        idAttribute = metaData.getSpecial("id");
                        ExampleSetMetaData newSet = new ExampleSetMetaData();
                        AttributeMetaData firstId = idAttribute.copy();
                        AttributeMetaData secondId = idAttribute.copy();
                        firstId.setName("FIRST_ID");
                        firstId.setRole("attribute");
                        secondId.setName("SECOND_ID");
                        secondId.setRole("attribute");
                        String name = "SIMILARITY";
                        try {
                            DistanceMeasure measure = DistanceMeasures.createMeasure(Similarity2ExampleSet.this);
                            if (measure.isDistance()) {
                                name = "DISTANCE";
                            }
                        }
                        catch (UndefinedParameterError e) {
                        }
                        catch (OperatorException e) {
                            // empty catch block
                        }
                        AttributeMetaData distanceAttribute = new AttributeMetaData(name, 4, "attribute");
                        newSet.addAttribute(firstId);
                        newSet.addAttribute(secondId);
                        newSet.addAttribute(distanceAttribute);
                        if (metaData.getNumberOfExamples().isKnown()) {
                            newSet.setNumberOfExamples((Integer)metaData.getNumberOfExamples().getValue() * ((Integer)metaData.getNumberOfExamples().getValue() - 1));
                        }
                        return newSet;
                    }
                    ExampleSetMetaData newSet = new ExampleSetMetaData();
                    if (metaData.getSpecial("id") == null && metaData.getNumberOfExamples().isKnown()) {
                        AttributeMetaData firstId = new AttributeMetaData("ID", 3, "id");
                        newSet.addAttribute(firstId);
                        for (int i = 1; i <= (Integer)metaData.getNumberOfExamples().getValue(); ++i) {
                            AttributeMetaData attr = new AttributeMetaData("" + i, 4);
                            attr.setValueRange(new Range(0.0, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
                            attr.setValueSetRelation(SetRelation.SUBSET);
                            newSet.addAttribute(attr);
                        }
                        newSet.setNumberOfExamples((Integer)metaData.getNumberOfExamples().getValue());
                    } else {
                        AttributeMetaData firstId = metaData.getSpecial("id").copy();
                        firstId.setName("ID");
                        newSet.addAttribute(firstId);
                        newSet.attributesAreSubset();
                    }
                    return newSet;
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    return metaData;
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        SimilarityMeasureObject measureObject = (SimilarityMeasureObject)this.similarityInput.getData();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.checkAndCreateIds(exampleSet);
        DistanceMeasure measure = measureObject.getDistanceMeasure();
        Attribute id = exampleSet.getAttributes().getId();
        if (id == null) {
            throw new UserError((Operator)this, 129);
        }
        ExampleSet result = null;
        if (this.getParameterAsInt(PARAMETER_TABLE_TYPE) == 0) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
            Attribute firstIdAttribute = AttributeFactory.createAttribute("FIRST_ID", id.getValueType());
            attributes.add(firstIdAttribute);
            Attribute secondIdAttribute = AttributeFactory.createAttribute("SECOND_ID", id.getValueType());
            attributes.add(secondIdAttribute);
            String name = "SIMILARITY";
            if (measure.isDistance()) {
                name = "DISTANCE";
            }
            Attribute similarityAttribute = AttributeFactory.createAttribute(name, 4);
            attributes.add(similarityAttribute);
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            int i = 0;
            for (Example example : exampleSet) {
                int j = 0;
                for (Example compExample : exampleSet) {
                    if (j != i) {
                        double[] data = new double[3];
                        if (id.isNominal()) {
                            data[0] = firstIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)example.getValue(id)));
                            data[1] = secondIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)compExample.getValue(id)));
                        } else {
                            data[0] = example.getValue(id);
                            data[1] = compExample.getValue(id);
                        }
                        data[2] = measure.isDistance() ? measure.calculateDistance(example, compExample) : measure.calculateSimilarity(example, compExample);
                        table.addDataRow(new DoubleArrayDataRow(data));
                    }
                    ++j;
                }
                ++i;
            }
            result = table.createExampleSet();
        } else {
            int numberOfExamples = exampleSet.size();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(numberOfExamples + 1);
            Attribute newIdAttribute = AttributeFactory.createAttribute("ID", id.getValueType());
            attributes.add(newIdAttribute);
            for (Example example : exampleSet) {
                Attribute attribute = id.getValueType() != 3 ? AttributeFactory.createAttribute(example.getValueAsString(id), 4) : AttributeFactory.createAttribute("" + (int)example.getValue(id), 4);
                attributes.add(attribute);
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (Example example : exampleSet) {
                double[] data = new double[numberOfExamples + 1];
                data[0] = id.isNominal() ? (double)newIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)example.getValue(id))) : example.getValue(id);
                int index = 1;
                for (Example compExample : exampleSet) {
                    if (measure.isDistance()) {
                        data[index++] = measure.calculateDistance(example, compExample);
                        continue;
                    }
                    data[index++] = measure.calculateSimilarity(example, compExample);
                }
                table.addDataRow(new DoubleArrayDataRow(data));
            }
            result = table.createExampleSet(null, null, newIdAttribute);
        }
        this.exampleSetOutput.deliver(result);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_TABLE_TYPE, "Indicates if the resulting table should have a matrix format or a long table format.", TABLE_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

