/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SimilarityExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.DistanceMeasurePrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasureHelper;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.List;

public class ExampleSet2SimilarityExampleSet
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("similarity example set");
    private DistanceMeasureHelper measureHelper = new DistanceMeasureHelper(this);

    public ExampleSet2SimilarityExampleSet(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new DistanceMeasurePrecondition(this.exampleSetInput, this));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                AttributeMetaData idAttribute = metaData.getSpecial("id");
                if (idAttribute == null) {
                    MetaDataTools.checkAndCreateIds(metaData);
                }
                idAttribute = metaData.getSpecial("id");
                ExampleSetMetaData newSet = new ExampleSetMetaData();
                AttributeMetaData firstId = idAttribute.copy();
                AttributeMetaData secondId = idAttribute.copy();
                firstId.setName("FIRST_ID");
                firstId.setRole("attribute");
                secondId.setName("SECOND_ID");
                secondId.setRole("attribute");
                String name = "SIMILARITY";
                try {
                    DistanceMeasure measure = DistanceMeasures.createMeasure(ExampleSet2SimilarityExampleSet.this);
                    if (measure.isDistance()) {
                        name = "DISTANCE";
                    }
                }
                catch (UndefinedParameterError e) {
                }
                catch (OperatorException e) {
                    // empty catch block
                }
                AttributeMetaData distanceAttribute = new AttributeMetaData(name, 4, "attribute");
                newSet.addAttribute(firstId);
                newSet.addAttribute(secondId);
                newSet.addAttribute(distanceAttribute);
                if (metaData.getNumberOfExamples().isKnown()) {
                    newSet.setNumberOfExamples((Integer)metaData.getNumberOfExamples().getValue() * (Integer)metaData.getNumberOfExamples().getValue());
                }
                return newSet;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.checkAndCreateIds(exampleSet);
        DistanceMeasure measure = this.measureHelper.getInitializedMeasure(exampleSet);
        this.exampleSetOutput.deliver(new SimilarityExampleSet(exampleSet, measure));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }
}

