/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.ExampleVisualizer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.DistanceMeasurePrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.similarity.SimilarityMeasureObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasureHelper;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.List;

public class ExampleSet2Similarity
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort similarityOutput = (OutputPort)this.getOutputPorts().createPort("similarity");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private DistanceMeasureHelper measureHelper = new DistanceMeasureHelper(this);

    public ExampleSet2Similarity(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new DistanceMeasurePrecondition(this.exampleSetInput, this));
        this.getTransformer().addRule(new GenerateNewMDRule(this.similarityOutput, new MetaData(SimilarityMeasureObject.class)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                MetaDataTools.checkAndCreateIds(metaData);
                return metaData;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.checkAndCreateIds(exampleSet);
        DistanceMeasure measure = this.measureHelper.getInitializedMeasure(exampleSet);
        SimilarityMeasureObject measureObject = new SimilarityMeasureObject(measure, exampleSet);
        ObjectVisualizerService.addObjectVisualizer(measureObject, new ExampleVisualizer(exampleSet));
        this.similarityOutput.deliver(measureObject);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }
}

