/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.similarity;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.BoundedPriorityQueue;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CrossDistancesOperator
extends Operator {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_USE_K = "only_top_k";
    public static final String PARAMETER_SEARCH_MODE = "search_for";
    private static final String[] SEARCH_MODE = new String[]{"nearest", "farthest"};
    private static final int MODE_NEAREST = 0;
    private static final int MODE_FARTHEST = 1;
    private InputPort requestSetInput = this.getInputPorts().createPort("request set", ExampleSet.class);
    private InputPort referenceSetInput = this.getInputPorts().createPort("reference set", ExampleSet.class);
    private OutputPort resultSetOutput = (OutputPort)this.getOutputPorts().createPort("result set");
    private OutputPort requestSetOutput = (OutputPort)this.getOutputPorts().createPort("request set");
    private OutputPort referenceSetOutput = (OutputPort)this.getOutputPorts().createPort("reference set");

    public CrossDistancesOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.referenceSetInput, this.referenceSetOutput);
        this.getTransformer().addPassThroughRule(this.requestSetInput, this.requestSetOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.resultSetOutput, ExampleSet.class){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                try {
                    ExampleSetMetaData refMD = (ExampleSetMetaData)CrossDistancesOperator.this.referenceSetInput.getMetaData();
                    ExampleSetMetaData requestMD = (ExampleSetMetaData)CrossDistancesOperator.this.requestSetInput.getMetaData();
                    if (refMD != null && requestMD != null) {
                        AttributeMetaData refId = refMD.getAttributeByRole("id");
                        AttributeMetaData requestId = requestMD.getAttributeByRole("id");
                        ExampleSetMetaData emd = new ExampleSetMetaData();
                        emd.addAttribute(new AttributeMetaData("request", requestId == null ? 4 : refId.getValueType()));
                        emd.addAttribute(new AttributeMetaData("document", refId == null ? 4 : refId.getValueType()));
                        emd.addAttribute(new AttributeMetaData("distance", 4));
                        return emd;
                    }
                    return unmodifiedMetaData;
                }
                catch (ClassCastException e) {
                    return unmodifiedMetaData;
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet requestSet = (ExampleSet)this.requestSetInput.getData();
        ExampleSet documentSet = (ExampleSet)this.referenceSetInput.getData();
        Tools.checkAndCreateIds(requestSet);
        Tools.checkAndCreateIds(documentSet);
        DistanceMeasure measure = DistanceMeasures.createMeasure(this);
        measure.init(documentSet);
        Attribute oldRequestId = requestSet.getAttributes().getId();
        Attribute oldDocumentId = documentSet.getAttributes().getId();
        Attribute requestId = AttributeFactory.createAttribute("request", oldRequestId.getValueType());
        Attribute documentId = AttributeFactory.createAttribute("document", oldDocumentId.getValueType());
        Attribute distance = AttributeFactory.createAttribute("distance", 4);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        Collections.addAll(newAttributes, requestId, documentId, distance);
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        double searchModeFactor = this.getParameterAsInt(PARAMETER_SEARCH_MODE) == 1 ? -1.0 : 1.0;
        for (Example request : requestSet) {
            AbstractCollection distances = this.getParameterAsBoolean(PARAMETER_USE_K) ? new BoundedPriorityQueue(this.getParameterAsInt(PARAMETER_K)) : new ArrayList();
            for (Example document : documentSet) {
                distances.add(new Tupel<Double, Double>(measure.calculateDistance(request, document) * searchModeFactor, document.getValue(oldDocumentId)));
            }
            DataRowFactory factory = new DataRowFactory(0, '.');
            double requestIdValue = request.getValue(oldRequestId);
            if (oldRequestId.isNominal()) {
                requestIdValue = requestId.getMapping().mapString(request.getValueAsString(oldRequestId));
            }
            for (Tupel tupel : distances) {
                double documentIdValue = (Double)tupel.getSecond();
                if (oldDocumentId.isNominal()) {
                    documentIdValue = documentId.getMapping().mapString(oldDocumentId.getMapping().mapIndex((int)documentIdValue));
                }
                DataRow row = factory.create(3);
                row.set(distance, (Double)tupel.getFirst() * searchModeFactor);
                row.set(requestId, requestIdValue);
                row.set(documentId, documentIdValue);
                table.addDataRow(row);
            }
        }
        SortedExampleSet result = new SortedExampleSet(table.createExampleSet(), distance, searchModeFactor == -1.0 ? 1 : 0);
        this.requestSetOutput.deliver(requestSet);
        this.referenceSetOutput.deliver(documentSet);
        this.resultSetOutput.deliver(result);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DistanceMeasures.getParameterTypes(this));
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_USE_K, "Only calculate the k nearest to each request example.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_K, "Determines how many of the nearest examples are shown in the result.", 1, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_K, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SEARCH_MODE, "Determines if the nearest or the farthest distances should be selected.", SEARCH_MODE, 0, false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_K, true, true));
        types.add(type);
        return types;
    }
}

