/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.weighting;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.local.LocalPolynomialRegressionModel;
import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.operator.learner.local.Neighborhoods;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.LinearRegression;
import com.rapidminer.tools.math.VectorMath;
import com.rapidminer.tools.math.container.LinearList;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import com.rapidminer.tools.math.smoothing.SmoothingKernel;
import com.rapidminer.tools.math.smoothing.SmoothingKernels;
import java.util.Collection;
import java.util.List;

public class LocalPolynomialExampleWeightingOperator
extends Operator {
    public static final double ROOT_OF_SIX = Math.sqrt(6.0);
    public static final String PARAMETER_NUMBER_OF_ITERATIONS = "iterations";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public LocalPolynomialExampleWeightingOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                if (metaData.containsSpecialAttribute("weight") != MetaDataInfo.NO) {
                    metaData.addAttribute(new AttributeMetaData("weight", 4, "weight"));
                }
                return metaData;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        exampleSet = this.doWork(exampleSet, this);
        this.exampleSetOutput.deliver(exampleSet);
    }

    public ExampleSet doWork(ExampleSet exampleSet, ParameterHandler handler) throws OperatorException {
        DistanceMeasure measure = DistanceMeasures.createMeasure(handler);
        measure.init(exampleSet);
        Attributes attributes = exampleSet.getAttributes();
        Attribute label = attributes.getLabel();
        Neighborhood neighborhood = Neighborhoods.createNeighborhood(handler);
        SmoothingKernel smoother = SmoothingKernels.createKernel(handler);
        int degree = handler.getParameterAsInt("degree");
        double ridge = handler.getParameterAsDouble("ridge_factor");
        int numberOfSteps = handler.getParameterAsInt(PARAMETER_NUMBER_OF_ITERATIONS);
        Attribute weightAttribute = attributes.getWeight();
        if (weightAttribute == null) {
            weightAttribute = AttributeFactory.createAttribute("weight", 4);
            exampleSet.getExampleTable().addAttribute(weightAttribute);
            attributes.addRegular(weightAttribute);
            attributes.setSpecialAttribute(weightAttribute, "weight");
        }
        for (Example example : exampleSet) {
            example.setValue(weightAttribute, 1.0);
        }
        for (int step = 0; step < numberOfSteps; ++step) {
            int i;
            LinearList<LocalPolynomialRegressionModel.RegressionData> data = new LinearList<LocalPolynomialRegressionModel.RegressionData>(measure);
            for (Example example : exampleSet) {
                double[] values = new double[attributes.size()];
                double labelValue = example.getValue(label);
                i = 0;
                for (Attribute attribute : attributes) {
                    values[i] = example.getValue(attribute);
                    ++i;
                }
                data.add(values, new LocalPolynomialRegressionModel.RegressionData(values, labelValue, example.getValue(weightAttribute)));
            }
            double[] residuals = new double[exampleSet.size()];
            double[] probe = new double[attributes.size()];
            int exampleIndex = 0;
            for (Example example : exampleSet) {
                i = 0;
                for (Attribute attribute : attributes) {
                    probe[i] = example.getValue(attribute);
                    ++i;
                }
                Collection localExamples = neighborhood.getNeighbourhood(data, probe);
                if (localExamples.size() > 1) {
                    double[][] x = new double[localExamples.size()][];
                    double[][] y = new double[localExamples.size()][1];
                    double[] distance = new double[localExamples.size()];
                    double[] weight = new double[localExamples.size()];
                    int j = 0;
                    for (Tupel tupel : localExamples) {
                        distance[j] = tupel.getFirst();
                        x[j] = VectorMath.polynomialExpansion(((LocalPolynomialRegressionModel.RegressionData)tupel.getSecond()).getExampleValues(), degree);
                        y[j][0] = ((LocalPolynomialRegressionModel.RegressionData)tupel.getSecond()).getExampleLabel();
                        weight[j] = ((LocalPolynomialRegressionModel.RegressionData)tupel.getSecond()).getExampleWeight();
                        ++j;
                    }
                    double maxDistance = Double.NEGATIVE_INFINITY;
                    for (j = 0; j < distance.length; ++j) {
                        maxDistance = maxDistance < distance[j] ? distance[j] : maxDistance;
                    }
                    for (j = 0; j < distance.length; ++j) {
                        weight[j] = weight[j] * smoother.getWeight(distance[j], maxDistance);
                    }
                    double[] coefficients = LinearRegression.performRegression(new Matrix((double[][])x), new Matrix(y), weight, ridge);
                    double[] probeExpaneded = VectorMath.polynomialExpansion(probe, degree);
                    double prediction = VectorMath.vectorMultiplication(probeExpaneded, coefficients);
                    residuals[exampleIndex] = Math.abs(example.getValue(label) - prediction);
                } else {
                    residuals[exampleIndex] = 0.0;
                }
                ++exampleIndex;
            }
            double median = VectorMath.getMedian(residuals);
            exampleIndex = 0;
            for (Example example : exampleSet) {
                example.setValue(weightAttribute, this.calculateRobustnessWeight(residuals[exampleIndex] / median));
                ++exampleIndex;
            }
        }
        return exampleSet;
    }

    private double calculateRobustnessWeight(double residual) {
        if (residual > ROOT_OF_SIX) {
            return 0.0;
        }
        double toQuad = 1.0 - residual * residual / 6.0;
        return toQuad * toQuad;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("degree", "Specifies the degree of the local fitted polynomial. Please keep in mind, that a higher degree than 2 will increase calculation time extremely and probably suffer from overfitting.", 0, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("ridge_factor", "Specifies the ridge factor. This factor is used to penalize high coefficients. In order to aviod overfitting this might be increased.", 0.0, Double.POSITIVE_INFINITY, 1.0E-9);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_ITERATIONS, "The number of iterations performed for weight calculation. See operator description for details.", 1, Integer.MAX_VALUE, 20);
        types.add(type);
        types.addAll(DistanceMeasures.getParameterTypesForNumericals(this));
        types.addAll(Neighborhoods.getParameterTypes(this));
        types.addAll(SmoothingKernels.getParameterTypes(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), LocalPolynomialExampleWeightingOperator.class, null);
    }
}

