/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.weighting.AbstractExampleWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.HashMap;
import java.util.List;

public class EqualLabelWeighting
extends AbstractExampleWeighting {
    private static final String PARAMETER_TOTAL_WEIGHT = "total_weight";

    public EqualLabelWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Range getWeightAttributeRange() {
        try {
            return new Range(0.0, this.getParameterAsDouble(PARAMETER_TOTAL_WEIGHT));
        }
        catch (UndefinedParameterError e) {
            return new Range(0.0, Double.POSITIVE_INFINITY);
        }
    }

    @Override
    protected SetRelation getWeightAttributeValueRelation() {
        return SetRelation.SUPERSET;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        if (exampleSet.getAttributes().getWeight() == null) {
            Attribute weight = AttributeFactory.createAttribute("weight", 2);
            exampleSet.getExampleTable().addAttribute(weight);
            exampleSet.getAttributes().addRegular(weight);
            exampleSet.getAttributes().setWeight(weight);
            Attribute label = exampleSet.getAttributes().getLabel();
            exampleSet.recalculateAttributeStatistics(label);
            NominalMapping labelMapping = label.getMapping();
            HashMap<String, Double> labelFrequencies = new HashMap<String, Double>();
            for (String labelName : labelMapping.getValues()) {
                labelFrequencies.put(labelName, exampleSet.getStatistics(label, "count", labelName));
            }
            double numberOfLabels = labelFrequencies.size();
            double perLabelWeight = this.getParameterAsDouble(PARAMETER_TOTAL_WEIGHT) / numberOfLabels;
            for (Example example : exampleSet) {
                double exampleWeight = perLabelWeight / (Double)labelFrequencies.get(labelMapping.mapIndex((int)example.getValue(label)));
                example.setValue(weight, exampleWeight);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_TOTAL_WEIGHT, "The total weight distributed over all examples.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), EqualLabelWeighting.class, null);
    }
}

