/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import com.rapidminer.tools.math.function.aggregation.VarianceFunction;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class GroupedANOVAOperator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private OutputPort significanceOutput = (OutputPort)this.getOutputPorts().createPort("significance");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    public static final String PARAMETER_ANOVA_ATTRIBUTE = "anova_attribute";
    public static final String PARAMETER_GROUP_BY_ATTRIBUTE = "group_by_attribute";
    public static final String PARAMETER_SIGNIFICANCE_LEVEL = "significance_level";
    public static final String PARAMETER_ONLY_DISTINCT = "only_distinct";

    public GroupedANOVAOperator(OperatorDescription desc) {
        super(desc);
        this.getTransformer().addRule(new GenerateNewMDRule(this.significanceOutput, SignificanceTestResult.class));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ANOVA_ATTRIBUTE), 2, new String[0]));
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_GROUP_BY_ATTRIBUTE), 1, new String[0]));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        this.significanceOutput.deliver(this.apply(exampleSet));
    }

    public SignificanceTestResult apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE);
        String groupByAttributeName = this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE);
        boolean onlyDistinct = this.getParameterAsBoolean(PARAMETER_ONLY_DISTINCT);
        Attribute anovaAttribute = exampleSet.getAttributes().get(attributeName);
        if (anovaAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE));
        }
        if (anovaAttribute.isNominal()) {
            throw new UserError((Operator)this, 104, "anova calculation", this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE));
        }
        Attribute groupByAttribute = exampleSet.getAttributes().get(groupByAttributeName);
        if (groupByAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE));
        }
        if (!groupByAttribute.isNominal()) {
            throw new UserError((Operator)this, 103, "the parameter grouping by", this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE));
        }
        AnovaCalculator anovaCalculator = new AnovaCalculator();
        double alpha = this.getParameterAsDouble(PARAMETER_SIGNIFICANCE_LEVEL);
        anovaCalculator.setAlpha(alpha);
        SplittedExampleSet grouped = SplittedExampleSet.splitByAttribute(exampleSet, groupByAttribute);
        AverageFunction meanFunction = new AverageFunction();
        VarianceFunction varianceFunction = new VarianceFunction();
        for (int i = 0; i < grouped.getNumberOfSubsets(); ++i) {
            grouped.selectSingleSubset(i);
            double[] values = this.getValues(grouped, anovaAttribute, onlyDistinct);
            double mean = meanFunction.calculate(values);
            double variance = varianceFunction.calculate(values);
            anovaCalculator.addGroup(grouped.size(), mean, variance);
        }
        SignificanceTestResult result = null;
        try {
            result = anovaCalculator.performSignificanceTest();
        }
        catch (SignificanceCalculationException e) {
            throw new UserError((Operator)this, 920, e.getMessage());
        }
        this.exampleSetOutput.deliver(exampleSet);
        return result;
    }

    private double[] getValues(ExampleSet exampleSet, Attribute attribute, boolean onlyDistinct) {
        AbstractCollection valueCollection = new LinkedList();
        if (onlyDistinct) {
            valueCollection = new TreeSet();
        }
        for (Example e : exampleSet) {
            valueCollection.add(e.getValue(attribute));
        }
        double[] result = new double[valueCollection.size()];
        int counter = 0;
        Iterator i$ = valueCollection.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            result[counter++] = d;
        }
        return result;
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ANOVA_ATTRIBUTE, "Calculate the ANOVA for this attribute based on the groups defines by group_by_attribute.", this.exampleSetInput, false));
        types.add(new ParameterTypeAttribute(PARAMETER_GROUP_BY_ATTRIBUTE, "Performs a grouping by the values of the attribute with this name.", this.exampleSetInput, false));
        types.add(new ParameterTypeDouble(PARAMETER_SIGNIFICANCE_LEVEL, "The significance level for the ANOVA calculation.", 0.0, 1.0, 0.05, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ONLY_DISTINCT, "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), GroupedANOVAOperator.class, null);
    }
}

