/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.transformation.ExampleSetTransformationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class Example2AttributePivoting
extends ExampleSetTransformationOperator {
    public static final String PARAMETER_GROUP_ATTRIBUTE = "group_attribute";
    public static final String PARAMETER_INDEX_ATTRIBUTE = "index_attribute";
    public static final String PARAMETER_CONSIDER_WEIGHTS = "consider_weights";
    public static final String PARAMETER_WEIGHT_AGGREGATION = "weight_aggregation";
    public static final String PARAMETER_SKIP_CONSTANT_ATTRIBUTES = "skip_constant_attributes";

    public Example2AttributePivoting(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_GROUP_ATTRIBUTE, PARAMETER_INDEX_ATTRIBUTE), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData groupAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_GROUP_ATTRIBUTE));
        AttributeMetaData indexAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE));
        if (groupAttribute != null && indexAttribute != null) {
            ExampleSetMetaData emd = new ExampleSetMetaData();
            if (groupAttribute.isNominal()) {
                emd.setNumberOfExamples(groupAttribute.getValueSet().size());
                if (groupAttribute.getValueSetRelation() == SetRelation.SUBSET) {
                    emd.getNumberOfExamples().reduceByUnknownAmount();
                } else if (groupAttribute.getValueSetRelation() == SetRelation.SUPERSET) {
                    emd.getNumberOfExamples().increaseByUnknownAmount();
                }
            } else {
                emd.setNumberOfExamples(new MDInteger());
            }
            if (indexAttribute.isNominal()) {
                for (AttributeMetaData originalAMD : metaData.getAllAttributes()) {
                    if (!originalAMD.isSpecial() && originalAMD != indexAttribute && originalAMD != groupAttribute) {
                        if (indexAttribute.getValueSet().size() > 1) {
                            for (String value : indexAttribute.getValueSet()) {
                                AttributeMetaData newIndexedAttribute = originalAMD.clone();
                                newIndexedAttribute.setName(originalAMD.getName() + "_" + value);
                                newIndexedAttribute.getNumberOfMissingValues().increaseByUnknownAmount();
                                newIndexedAttribute.setValueSetRelation(SetRelation.SUBSET);
                                emd.addAttribute(newIndexedAttribute);
                                emd.mergeSetRelation(newIndexedAttribute.getValueSetRelation());
                            }
                        } else {
                            AttributeMetaData newIndexedAttribute = originalAMD.clone();
                            emd.addAttribute(newIndexedAttribute);
                        }
                    }
                    if (originalAMD != groupAttribute) continue;
                    emd.addAttribute(originalAMD.clone());
                }
            } else {
                for (AttributeMetaData originalAMD : metaData.getAllAttributes()) {
                    if (!originalAMD.isSpecial() && originalAMD != indexAttribute && originalAMD != groupAttribute) {
                        AttributeMetaData newIndexedAttribute = originalAMD.clone();
                        newIndexedAttribute.setName(originalAMD.getName() + "_" + newIndexedAttribute.getValueRange().getLower());
                        newIndexedAttribute.getNumberOfMissingValues().increaseByUnknownAmount();
                        newIndexedAttribute.setValueSetRelation(SetRelation.SUBSET);
                        emd.addAttribute(newIndexedAttribute);
                        newIndexedAttribute = originalAMD.clone();
                        newIndexedAttribute.setName(originalAMD.getName() + "_" + newIndexedAttribute.getValueRange().getUpper());
                        newIndexedAttribute.getNumberOfMissingValues().increaseByUnknownAmount();
                        newIndexedAttribute.setValueSetRelation(SetRelation.SUBSET);
                        emd.addAttribute(newIndexedAttribute);
                    }
                    if (originalAMD != groupAttribute) continue;
                    emd.addAttribute(originalAMD.clone());
                }
                emd.mergeSetRelation(SetRelation.SUPERSET);
            }
            return emd;
        }
        return new ExampleSetMetaData();
    }

    @Override
    public ExampleSet apply(ExampleSet sourceExampleSet) throws OperatorException {
        boolean skipConstantAttributes = this.getParameterAsBoolean(PARAMETER_SKIP_CONSTANT_ATTRIBUTES);
        String groupAttributeName = this.getParameterAsString(PARAMETER_GROUP_ATTRIBUTE);
        String indexAttributeName = this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE);
        boolean considerWeights = this.getParameterAsBoolean(PARAMETER_CONSIDER_WEIGHTS);
        int weightAggregationFunctionIndex = this.getParameterAsInt(PARAMETER_WEIGHT_AGGREGATION);
        Attribute groupAttribute = sourceExampleSet.getAttributes().get(groupAttributeName);
        if (groupAttribute == null) {
            throw new UserError((Operator)this, 111, groupAttributeName);
        }
        Attribute indexAttribute = sourceExampleSet.getAttributes().get(indexAttributeName);
        if (indexAttribute == null) {
            throw new UserError((Operator)this, 111, indexAttributeName);
        }
        Attribute weightAttribute = sourceExampleSet.getAttributes().getWeight();
        SortedExampleSet exampleSet = new SortedExampleSet(sourceExampleSet, groupAttribute, 0);
        Vector<String> indexValues = new Vector<String>();
        Attribute[] attributes = exampleSet.getAttributes().createRegularAttributeArray();
        boolean[] constantAttributeValues = new boolean[attributes.length];
        for (int i = 0; i < constantAttributeValues.length; ++i) {
            constantAttributeValues[i] = true;
        }
        Example lastExample = null;
        for (Example example : exampleSet) {
            String indexValue;
            if (lastExample != null && lastExample.getValue(groupAttribute) == example.getValue(groupAttribute)) {
                for (int i = 0; i < attributes.length; ++i) {
                    Attribute attribute = attributes[i];
                    if (Double.isNaN(lastExample.getValue(attribute)) && Double.isNaN(example.getValue(attribute)) || lastExample.getValue(attribute) == example.getValue(attribute)) continue;
                    constantAttributeValues[i] = false;
                }
            }
            if (!indexValues.contains(indexValue = example.getValueAsString(indexAttribute))) {
                indexValues.add(indexValue);
            }
            lastExample = example;
        }
        if (!indexAttribute.isNominal()) {
            Collections.sort(indexValues);
        }
        Vector<String> attributeNames = new Vector<String>();
        Vector<Attribute> newAttributes = new Vector<Attribute>();
        Attribute newWeightAttribute = null;
        if (weightAttribute != null && considerWeights) {
            newWeightAttribute = AttributeFactory.createAttribute(weightAttribute.getName(), 4);
            newAttributes.add(newWeightAttribute);
            attributeNames.add(newWeightAttribute.getName());
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (((Object)attribute).equals(indexAttribute)) continue;
            if (skipConstantAttributes && constantAttributeValues[i] || ((Object)attribute).equals(groupAttribute)) {
                newAttributes.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
                attributeNames.add(attribute.getName());
                continue;
            }
            for (String indexValue : indexValues) {
                String newAttributeName = attribute.getName() + "_" + indexValue;
                newAttributes.add(AttributeFactory.createAttribute(newAttributeName, attribute.getValueType()));
                attributeNames.add(newAttributeName);
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        AggregationFunction aggregationFunction = null;
        if (newWeightAttribute != null && considerWeights) {
            try {
                aggregationFunction = AbstractAggregationFunction.createAggregationFunction(weightAggregationFunctionIndex);
            }
            catch (Exception e) {
                throw new UserError((Operator)this, 904, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[weightAggregationFunctionIndex], e.getMessage());
            }
        }
        lastExample = null;
        double[] data = new double[newAttributes.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = Double.NaN;
        }
        for (Example example : exampleSet) {
            int i;
            if (lastExample != null && lastExample.getValue(groupAttribute) != example.getValue(groupAttribute)) {
                if (aggregationFunction != null) {
                    data[0] = aggregationFunction.getValue();
                    try {
                        aggregationFunction = AbstractAggregationFunction.createAggregationFunction(weightAggregationFunctionIndex);
                    }
                    catch (Exception e) {
                        throw new UserError((Operator)this, 904, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[weightAggregationFunctionIndex], e.getMessage());
                    }
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                data = new double[newAttributes.size()];
                for (i = 0; i < data.length; ++i) {
                    data[i] = Double.NaN;
                }
            }
            if (aggregationFunction != null) {
                aggregationFunction.update(example.getWeight());
            }
            for (i = 0; i < attributes.length; ++i) {
                double value;
                Attribute attribute = attributes[i];
                int newIndex = -1;
                if (skipConstantAttributes && constantAttributeValues[i] || ((Object)attribute).equals(groupAttribute)) {
                    newIndex = attributeNames.indexOf(attribute.getName());
                } else {
                    String newAttributeName = attribute.getName() + "_" + example.getValueAsString(indexAttribute);
                    newIndex = attributeNames.indexOf(newAttributeName);
                }
                if (newIndex == -1 || Double.isNaN(value = example.getValue(attribute))) continue;
                data[newIndex] = attribute.isNominal() ? (double)((Attribute)newAttributes.get(newIndex)).getMapping().mapString(attribute.getMapping().mapIndex((int)value)) : value;
            }
            lastExample = example;
        }
        if (aggregationFunction != null) {
            data[0] = aggregationFunction.getValue();
        }
        table.addDataRow(new DoubleArrayDataRow(data));
        ExampleSet result = table.createExampleSet();
        if (newWeightAttribute != null) {
            result.getAttributes().setWeight(newWeightAttribute);
        }
        result.recalculateAllAttributeStatistics();
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_GROUP_ATTRIBUTE, "Attribute that groups the examples which form one example after pivoting.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeAttribute(PARAMETER_INDEX_ATTRIBUTE, "Attribute which differentiates examples inside a group.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeBoolean(PARAMETER_CONSIDER_WEIGHTS, "Determines whether weights will be kept and aggregated or ignored.", true, false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_WEIGHT_AGGREGATION, "Specifies how example weights are aggregated in the groups.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 6, false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_CONSIDER_WEIGHTS, true, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_CONSTANT_ATTRIBUTES, "Skips attributes if their value never changes within a group.", true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Example2AttributePivoting.class, null);
    }
}

