/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.transformation.ExampleSetTransformationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Attribute2ExamplePivoting
extends ExampleSetTransformationOperator {
    public static final String PARAMETER_ATTRIBUTE_NAME_REGEX = "attributes";
    public static final String PARAMETER_SERIES = "attribute_name";
    public static final String PARAMETER_INDEX_ATTRIBUTE = "index_attribute";
    public static final String PARAMETER_KEEP_MISSINGS = "keep_missings";
    public static final String PARAMETER_CREATE_NOMINAL_INDEX = "create_nominal_index";

    public Attribute2ExamplePivoting(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort()));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        List<String[]> seriesList = this.getParameterList(PARAMETER_SERIES);
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.getNumberOfExamples().increaseByUnknownAmount();
        emd.mergeSetRelation(SetRelation.SUBSET);
        int numberOfSeries = seriesList.size();
        boolean createNominalIndex = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_INDEX);
        if (numberOfSeries > 1 && createNominalIndex) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_CREATE_NOMINAL_INDEX, "false")), "parameter_combination_number_forbidden", PARAMETER_CREATE_NOMINAL_INDEX, PARAMETER_SERIES, "1"));
        }
        String[] seriesNames = new String[numberOfSeries];
        Pattern[] seriesPatterns = new Pattern[numberOfSeries];
        ArrayList seriesAttributes = new ArrayList(numberOfSeries);
        int[] attributeTypes = new int[numberOfSeries];
        Iterator<String[]> iterator = seriesList.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            seriesNames[j] = pair[0];
            seriesPatterns[j] = Pattern.compile(pair[1]);
            seriesAttributes.add(j, new Vector());
            ++j;
        }
        for (AttributeMetaData attribute : metaData.getAllAttributes()) {
            if (attribute.isSpecial()) continue;
            boolean matched = false;
            for (int i = 0; i < numberOfSeries; ++i) {
                Matcher matcher = seriesPatterns[i].matcher(attribute.getName());
                if (!matcher.matches()) continue;
                matched = true;
                ((Vector)seriesAttributes.get(i)).add(attribute);
                attributeTypes[i] = attribute.getValueType();
                break;
            }
            if (matched) continue;
            emd.addAttribute(attribute);
        }
        if (!createNominalIndex) {
            emd.addAttribute(new AttributeMetaData(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 3));
        } else {
            emd.addAttribute(new AttributeMetaData(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 7));
        }
        for (int i = 0; i < numberOfSeries; ++i) {
            emd.addAttribute(new AttributeMetaData(seriesNames[i], attributeTypes[i]));
        }
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            amd.getNumberOfMissingValues().increaseByUnknownAmount();
        }
        return emd;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int i;
        List<String[]> seriesList = this.getParameterList(PARAMETER_SERIES);
        int numberOfSeries = seriesList.size();
        boolean createNominalIndex = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_INDEX);
        if (numberOfSeries > 1 && createNominalIndex) {
            throw new UserError((Operator)this, 207, "true", PARAMETER_CREATE_NOMINAL_INDEX, "More than one series listed in attribute names");
        }
        String[] seriesNames = new String[numberOfSeries];
        Pattern[] seriesPatterns = new Pattern[numberOfSeries];
        ArrayList seriesAttributes = new ArrayList(numberOfSeries);
        int[] attributeTypes = new int[numberOfSeries];
        Iterator<String[]> iterator = seriesList.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            seriesNames[j] = pair[0];
            seriesPatterns[j] = Pattern.compile(pair[1]);
            seriesAttributes.add(j, new Vector());
            attributeTypes[j] = 0;
            ++j;
        }
        Vector<Attribute> newAttributes = new Vector<Attribute>();
        Vector<Attribute> constantAttributes = new Vector<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            boolean matched = false;
            for (i = 0; i < numberOfSeries; ++i) {
                Matcher matcher = seriesPatterns[i].matcher(attribute.getName());
                if (!matcher.matches()) continue;
                matched = true;
                ((Vector)seriesAttributes.get(i)).add(attribute);
                if (attributeTypes[i] != 0) {
                    if (attribute.getValueType() == attributeTypes[i]) break;
                    throw new OperatorException("attributes have different value types: no conversion is performed");
                }
                attributeTypes[i] = attribute.getValueType();
                break;
            }
            if (matched) continue;
            Attribute attributeCopy = AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType());
            if (attribute.isNominal()) {
                attributeCopy.setMapping((NominalMapping)attribute.getMapping().clone());
            }
            newAttributes.add(attributeCopy);
            constantAttributes.add(attribute);
        }
        int seriesLength = 0;
        if (numberOfSeries >= 1) {
            seriesLength = ((Vector)seriesAttributes.get(0)).size();
            for (i = 0; i < numberOfSeries - 1; ++i) {
                seriesLength = ((Vector)seriesAttributes.get(i)).size();
                if (seriesLength == ((Vector)seriesAttributes.get(i + 1)).size()) continue;
                throw new OperatorException("series must have the same length: no conversion is performed");
            }
        }
        Attribute indexAttribute = !createNominalIndex ? AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 3) : AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 7);
        newAttributes.add(indexAttribute);
        for (int i2 = 0; i2 < numberOfSeries; ++i2) {
            if (attributeTypes[i2] == 0) {
                this.logError("Cannot create pivot attribute " + seriesNames[i2] + ": No matching attributes found.");
                continue;
            }
            Attribute seriesAttribute = AttributeFactory.createAttribute(seriesNames[i2], attributeTypes[i2]);
            newAttributes.add(seriesAttribute);
        }
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        for (Example example : exampleSet) {
            int l = 0;
            for (int k = 0; k < seriesLength; ++k) {
                int i3;
                ++l;
                double[] data = new double[newAttributes.size()];
                for (i3 = 0; i3 < data.length; ++i3) {
                    data[i3] = Double.NaN;
                }
                for (i3 = 0; i3 < constantAttributes.size(); ++i3) {
                    data[i3] = example.getValue((Attribute)constantAttributes.get(i3));
                }
                data[data.length - numberOfSeries - 1] = !createNominalIndex ? (double)l : (double)indexAttribute.getMapping().mapString(((Attribute)((Vector)seriesAttributes.get(0)).get(k)).getName());
                boolean onlyMissings = true;
                for (int i4 = 0; i4 < numberOfSeries; ++i4) {
                    Attribute seriesAttribute = (Attribute)((Vector)seriesAttributes.get(i4)).get(k);
                    double seriesValue = example.getValue(seriesAttribute);
                    double newValue = Double.NaN;
                    if (!Double.isNaN(seriesValue)) {
                        newValue = seriesAttribute.isNominal() ? (double)newAttributes.get(newAttributes.size() - numberOfSeries + i4).getMapping().mapString(seriesAttribute.getMapping().mapIndex((int)seriesValue)) : seriesValue;
                        onlyMissings = false;
                    }
                    data[data.length - numberOfSeries + i4] = newValue;
                }
                this.checkForStop();
                if (!this.getParameterAsBoolean(PARAMETER_KEEP_MISSINGS) && onlyMissings) continue;
                table.addDataRow(new DoubleArrayDataRow(data));
            }
        }
        ExampleSet result = table.createExampleSet();
        result.recalculateAllAttributeStatistics();
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeList(PARAMETER_SERIES, "Maps a number of source attributes onto result attributes.", (ParameterType)new ParameterTypeString(PARAMETER_SERIES, "Specifies the name of the resulting attribute"), (ParameterType)new ParameterTypeRegexp(PARAMETER_ATTRIBUTE_NAME_REGEX, "Attributes that forms series.", false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_INDEX_ATTRIBUTE, "Name of newly created index attribute.", false, false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CREATE_NOMINAL_INDEX, "Indicates if the index attribute should contain the full attribute name. (Only works with one group)", false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_MISSINGS, "Keep missing values.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Attribute2ExamplePivoting.class, null);
    }
}

