/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.preprocessing.filter.NumericToNominal;
import com.rapidminer.operator.preprocessing.filter.NumericToPolynominal;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.container.MultidimensionalArraySet;
import com.rapidminer.tools.container.ValueSet;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AggregationOperator
extends AbstractDataProcessing {
    public static final String PARAMETER_AGGREGATION_ATTRIBUTES = "aggregation_attributes";
    public static final String PARAMETER_AGGREGATION_FUNCTIONS = "aggregation_functions";
    public static final String PARAMETER_GROUP_BY_ATTRIBUTES = "group_by_attributes";
    public static final String PARAMETER_ONLY_DISTINCT = "only_distinct";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    public static final String GENERIC_GROUP_NAME = "group";
    public static final String GENERIC_ALL_NAME = "all";
    public static final String PARAMETER_ALL_COMBINATIONS = "count_all_combinations";

    public AggregationOperator(OperatorDescription desc) {
        super(desc);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        String attributeRegex = this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTES);
        if (attributeRegex != null) {
            Pattern pattern = Pattern.compile(attributeRegex);
            Iterator<AttributeMetaData> iterator = metaData.getAllAttributes().iterator();
            while (iterator.hasNext()) {
                AttributeMetaData amd = iterator.next();
                if (pattern.matcher(amd.getName()).matches()) continue;
                iterator.remove();
            }
        } else {
            metaData.removeAllAttributes();
            AttributeMetaData allGroup = new AttributeMetaData(GENERIC_GROUP_NAME, 1);
            TreeSet<String> values = new TreeSet<String>();
            values.add(GENERIC_ALL_NAME);
            allGroup.setValueSet(values, SetRelation.EQUAL);
            metaData.addAttribute(allGroup);
            metaData.setNumberOfExamples(new MDInteger(1));
        }
        List<String[]> parameterList = this.getParameterList(PARAMETER_AGGREGATION_ATTRIBUTES);
        for (String[] function : parameterList) {
            metaData.addAttribute(new AttributeMetaData(function[1] + "(" + function[0] + ")", 4));
        }
        if (attributeRegex != null) {
            metaData.getNumberOfExamples().reduceByUnknownAmount();
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet = (ExampleSet)exampleSet.clone();
        boolean onlyDistinctValues = this.getParameterAsBoolean(PARAMETER_ONLY_DISTINCT);
        boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
        List<String[]> parameterList = this.getParameterList(PARAMETER_AGGREGATION_ATTRIBUTES);
        int aggregations = parameterList.size();
        Attribute[] aggregationAttributes = new Attribute[aggregations];
        String[] aggregationFunctionNames = new String[aggregations];
        int[] resultTypes = new int[aggregations];
        int parameterListIndex = 0;
        for (String[] valuePair : parameterList) {
            String attributeName = valuePair[0];
            String aggregationFunctionName = valuePair[1];
            Attribute attribute = exampleSet.getAttributes().get(attributeName);
            if (attribute == null) {
                throw new UserError((Operator)this, 111, attributeName);
            }
            aggregationAttributes[parameterListIndex] = attribute;
            aggregationFunctionNames[parameterListIndex] = aggregationFunctionName;
            resultTypes[parameterListIndex] = aggregationFunctionName.equals(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[3]) ? 2 : (attribute.isNumerical() ? 2 : (attribute.isNominal() ? 1 : attribute.getValueType()));
            ++parameterListIndex;
        }
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        MemoryExampleTable resultTable = null;
        boolean allCombinations = this.getParameterAsBoolean(PARAMETER_ALL_COMBINATIONS);
        if (this.isParameterSet(PARAMETER_GROUP_BY_ATTRIBUTES)) {
            int i;
            String groupByAttributesRegex = this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTES);
            try {
                NumericToNominal toNominalOperator = OperatorService.createOperator(NumericToPolynominal.class);
                toNominalOperator.setParameter("attribute_filter_type", "3");
                toNominalOperator.setParameter("regular_expression", groupByAttributesRegex);
                toNominalOperator.setParameter("include_special_attributes", "true");
                exampleSet = toNominalOperator.apply(exampleSet);
            }
            catch (OperatorCreationException e) {
                // empty catch block
            }
            Attribute[] groupByAttributes = this.getAttributesArrayFromRegex(exampleSet.getAttributes(), groupByAttributesRegex);
            if (groupByAttributes.length == 0) {
                throw new UserError((Operator)this, 111, groupByAttributesRegex);
            }
            int[] mappingSizes = new int[groupByAttributes.length];
            for (int i2 = 0; i2 < groupByAttributes.length; ++i2) {
                if (groupByAttributes[i2].isNumerical()) {
                    throw new UserError((Operator)this, 103, groupByAttributesRegex, "grouping by attribute.");
                }
                mappingSizes[i2] = groupByAttributes[i2].getMapping().size();
            }
            MultidimensionalArraySet<AggregationFunction[]> functionSet = new MultidimensionalArraySet<AggregationFunction[]>(mappingSizes);
            if (onlyDistinctValues && !allCombinations) {
                MultidimensionalArraySet<ValueSet[]> distinctValueSet = new MultidimensionalArraySet<ValueSet[]>(mappingSizes);
                for (Example example : exampleSet) {
                    int[] indices = new int[groupByAttributes.length];
                    for (int i3 = 0; i3 < groupByAttributes.length; ++i3) {
                        indices[i3] = (int)example.getValue(groupByAttributes[i3]);
                    }
                    ValueSet[] distinctValues = (ValueSet[])distinctValueSet.get(indices);
                    if (distinctValues == null) {
                        distinctValues = new ValueSet[aggregations];
                        for (int j = 0; j < aggregations; ++j) {
                            distinctValues[j] = new ValueSet();
                        }
                        distinctValueSet.set(indices, distinctValues);
                    }
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    for (int i4 = 0; i4 < aggregations; ++i4) {
                        distinctValues[i4].add(example.getValue(aggregationAttributes[i4]), weight);
                    }
                }
                for (int i5 = 0; i5 < functionSet.size(); ++i5) {
                    int j;
                    ValueSet[] distinctValues = (ValueSet[])distinctValueSet.get(i5);
                    if (distinctValues == null) continue;
                    AggregationFunction[] functions = new AggregationFunction[aggregations];
                    for (j = 0; j < aggregations; ++j) {
                        functions[j] = this.getAggregationFunction(aggregationFunctionNames[j], ignoreMissings, aggregationAttributes[j]);
                    }
                    functionSet.set(i5, functions);
                    for (j = 0; j < aggregations; ++j) {
                        for (Double value : distinctValues[j]) {
                            functions[j].update(value);
                        }
                    }
                }
            } else {
                if (allCombinations) {
                    this.registerAllCombinations(groupByAttributes, functionSet, aggregationFunctionNames, ignoreMissings, aggregationAttributes);
                }
                for (Example example : exampleSet) {
                    int[] indices = new int[groupByAttributes.length];
                    for (int i6 = 0; i6 < groupByAttributes.length; ++i6) {
                        indices[i6] = (int)example.getValue(groupByAttributes[i6]);
                    }
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    AggregationFunction[] functions = functionSet.get(indices);
                    if (functions == null) {
                        functions = new AggregationFunction[aggregations];
                        for (int j = 0; j < aggregations; ++j) {
                            functions[j] = this.getAggregationFunction(aggregationFunctionNames[j], ignoreMissings, aggregationAttributes[j]);
                        }
                        functionSet.set(indices, functions);
                    }
                    for (int i7 = 0; i7 < aggregations; ++i7) {
                        functions[i7].update(example.getValue(aggregationAttributes[i7]), weight);
                    }
                }
            }
            LinkedList<Attribute> resultAttributes = new LinkedList<Attribute>();
            Attribute[] resultGroupAttributes = new Attribute[groupByAttributes.length];
            for (i = 0; i < groupByAttributes.length; ++i) {
                Attribute resultGroupAttribute = AttributeFactory.createAttribute(groupByAttributes[i].getName(), 1);
                for (int j = 0; j < groupByAttributes[i].getMapping().size(); ++j) {
                    resultGroupAttribute.getMapping().mapString(groupByAttributes[i].getMapping().mapIndex(j));
                }
                resultAttributes.add(resultGroupAttribute);
                resultGroupAttributes[i] = resultGroupAttribute;
            }
            for (i = 0; i < aggregations; ++i) {
                resultAttributes.add(AttributeFactory.createAttribute(aggregationFunctionNames[i] + "(" + aggregationAttributes[i].getName() + ")", resultTypes[i]));
            }
            resultTable = new MemoryExampleTable(resultAttributes);
            for (i = 0; i < functionSet.size(); ++i) {
                double[] data = new double[groupByAttributes.length + aggregations];
                int[] indices = functionSet.getIndices(i);
                for (int j = 0; j < groupByAttributes.length; ++j) {
                    data[j] = indices[j];
                }
                AggregationFunction[] functions = functionSet.get(i);
                if (functions == null) continue;
                for (int j = 0; j < aggregations; ++j) {
                    data[groupByAttributes.length + j] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(resultTypes[j], 1) ? (double)resultTable.getAttribute(groupByAttributes.length + j).getMapping().mapString(aggregationAttributes[j].getMapping().mapIndex((int)functions[j].getValue())) : functions[j].getValue();
                }
                resultTable.addDataRow(new DoubleArrayDataRow(data));
            }
        } else {
            AggregationFunction[] functions = new AggregationFunction[aggregations];
            for (int i = 0; i < aggregations; ++i) {
                functions[i] = this.getAggregationFunction(aggregationFunctionNames[i], ignoreMissings, aggregationAttributes[i]);
            }
            if (onlyDistinctValues) {
                ValueSet[] distinctValues = new ValueSet[aggregations];
                for (int i = 0; i < aggregations; ++i) {
                    distinctValues[i] = new ValueSet();
                }
                for (Example example : exampleSet) {
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    for (int i = 0; i < distinctValues.length; ++i) {
                        distinctValues[i].add(example.getValue(aggregationAttributes[i]), weight);
                    }
                }
                for (int i = 0; i < distinctValues.length; ++i) {
                    for (Double value : distinctValues[i]) {
                        functions[i].update(value);
                    }
                }
            } else {
                for (Example example : exampleSet) {
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    for (int i = 0; i < functions.length; ++i) {
                        functions[i].update(example.getValue(aggregationAttributes[i]), weight);
                    }
                }
            }
            LinkedList<Attribute> resultAttributes = new LinkedList<Attribute>();
            Attribute resultGroupAttribute = AttributeFactory.createAttribute(GENERIC_GROUP_NAME, 1);
            resultAttributes.add(resultGroupAttribute);
            for (int i = 0; i < aggregations; ++i) {
                resultAttributes.add(AttributeFactory.createAttribute(aggregationFunctionNames[i] + "(" + aggregationAttributes[i].getName() + ")", resultTypes[i]));
            }
            for (Attribute attribute : resultAttributes) {
                attribute.setConstruction(attribute.getName());
            }
            resultTable = new MemoryExampleTable(resultAttributes);
            double[] data = new double[aggregations + 1];
            data[0] = resultGroupAttribute.getMapping().mapString(GENERIC_ALL_NAME);
            for (int i = 0; i < aggregations; ++i) {
                data[i + 1] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(resultTypes[i], 1) ? (double)resultTable.getAttribute(i + 1).getMapping().mapString(aggregationAttributes[i].getMapping().mapIndex((int)functions[i].getValue())) : functions[i].getValue();
            }
            resultTable.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet resultSet = resultTable.createExampleSet();
        return resultSet;
    }

    private void registerAllCombinations(Attribute[] groupByAttributes, MultidimensionalArraySet<AggregationFunction[]> functionSet, String[] aggregationFunctionNames, boolean ignoreMissings, Attribute[] aggregationAttributes) throws UserError {
        this.registerAllCombinationsRecursion(groupByAttributes, functionSet, aggregationFunctionNames, ignoreMissings, aggregationAttributes, new int[groupByAttributes.length], 0);
    }

    private void registerAllCombinationsRecursion(Attribute[] groupByAttributes, MultidimensionalArraySet<AggregationFunction[]> functionSet, String[] aggregationFunctionNames, boolean ignoreMissings, Attribute[] aggregationAttributes, int[] indices, int depth) throws UserError {
        if (depth == indices.length) {
            AggregationFunction[] functions = new AggregationFunction[aggregationFunctionNames.length];
            for (int j = 0; j < aggregationFunctionNames.length; ++j) {
                functions[j] = this.getAggregationFunction(aggregationFunctionNames[j], ignoreMissings, aggregationAttributes[j]);
            }
            functionSet.set(indices, functions);
        } else {
            NominalMapping mapping = groupByAttributes[depth].getMapping();
            for (String value : mapping.getValues()) {
                indices[depth] = mapping.getIndex(value);
                this.registerAllCombinationsRecursion(groupByAttributes, functionSet, aggregationFunctionNames, ignoreMissings, aggregationAttributes, indices, depth + 1);
            }
        }
    }

    private AggregationFunction getAggregationFunction(String functionName, boolean ignoreMissings, Attribute attribute) throws UserError {
        AggregationFunction function;
        try {
            function = AbstractAggregationFunction.createAggregationFunction(functionName, ignoreMissings);
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        if (!function.supportsAttribute(attribute)) {
            throw new UserError((Operator)this, 136, attribute.getName());
        }
        return function;
    }

    private Attribute[] getAttributesArrayFromRegex(Attributes attributes, String regex) throws OperatorException {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        Iterator<Attribute> i = attributes.allAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (!matcher.matches()) continue;
            attributeList.add(attribute);
        }
        Attribute[] attributesArray = new Attribute[attributeList.size()];
        attributesArray = attributeList.toArray(attributesArray);
        return attributesArray;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_AGGREGATION_ATTRIBUTES, "The attributes which should be aggregated.", (ParameterType)new ParameterTypeAttribute("aggregation_attribute", "Specifies the attribute which is aggregated.", this.getExampleSetInputPort()), (ParameterType)new ParameterTypeStringCategory(PARAMETER_AGGREGATION_FUNCTIONS, "The type of the used aggregation function.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[0]), false));
        types.add(new ParameterTypeAttributes(PARAMETER_GROUP_BY_ATTRIBUTES, "Performs a grouping by the values of the attributes whose names match the given regular expression.", this.getExampleSetInputPort(), true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ALL_COMBINATIONS, "Indicates that all possible combinations of the values of the group by attributes are counted, even if they don't occur. Please handle with care, since the number might be enormous.", false));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ONLY_DISTINCT, "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_ALL_COMBINATIONS, false, false));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Indicates if missings should be ignored and aggregation should be based only on existing values or not. In the latter case the aggregated value will be missing in the presence of missing values.", true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AggregationOperator.class, null);
    }
}

