/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.Collections;
import java.util.List;

public class StratifiedSamplingOperator
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE = "sample";
    public static final String[] SAMPLE_MODES = new String[]{"absolute", "relative"};
    public static final int SAMPLE_ABSOLUTE = 0;
    public static final int SAMPLE_RELATIVE = 1;
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";

    public StratifiedSamplingOperator(OperatorDescription description) {
        super(description);
    }

    public double getRatio(ExampleSet exampleSet) throws OperatorException {
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                double targetSize = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                if (targetSize > (double)exampleSet.size()) {
                    return 1.0;
                }
                return targetSize / (double)exampleSet.size();
            }
            case 1: {
                return this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
            }
        }
        return 1.0;
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                int absoluteNumber = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                if (emd.getNumberOfExamples().isAtLeast(absoluteNumber) == MetaDataInfo.NO) {
                    this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_SAMPLE_SIZE, ((Integer)emd.getNumberOfExamples().getValue()).toString())), "exampleset.need_more_examples", absoluteNumber + ""));
                }
                return new MDInteger(absoluteNumber);
            }
            case 1: {
                MDInteger number = emd.getNumberOfExamples();
                number.multiply(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
                return number;
            }
        }
        return new MDInteger();
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        SplittedExampleSet splittedExampleSet = new SplittedExampleSet(exampleSet, this.getRatio(exampleSet), 2, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        splittedExampleSet.selectSingleSubset(0);
        return splittedExampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_SAMPLE, "Determines how the amount of data is specified.", SAMPLE_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), StratifiedSamplingOperator.class, null);
    }
}

