/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.operator.preprocessing.sampling.sequences.AbsoluteSamplingSequenceGenerator;
import com.rapidminer.operator.preprocessing.sampling.sequences.ProbabilitySamplingSequenceGenerator;
import com.rapidminer.operator.preprocessing.sampling.sequences.RelativeSamplingSequenceGenerator;
import com.rapidminer.operator.preprocessing.sampling.sequences.SamplingSequenceGenerator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.Collections;
import java.util.List;

public class SamplingOperator
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE = "sample";
    public static String[] SAMPLE_MODES = new String[]{"absolute", "relative", "probability"};
    public static final int SAMPLE_ABSOLUTE = 0;
    public static final int SAMPLE_RELATIVE = 1;
    public static final int SAMPLE_PROBABILITY = 2;
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_PROBABILITY = "sample_probability";
    public static final String PARAMETER_BALANCE_DATA = "balance_data";
    public static final String PARAMETER_SAMPLE_SIZE_LIST = "sample_size_per_class";
    public static final String PARAMETER_SAMPLE_RATIO_LIST = "sample_ratio_per_class";
    public static final String PARAMETER_SAMPLE_PROBABILITY_LIST = "sample_probability_per_class";

    public SamplingOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        boolean balanceData = this.getParameterAsBoolean(PARAMETER_BALANCE_DATA);
        int absoluteNumber = 0;
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                if (balanceData) {
                    List<String[]> parameterList = this.getParameterList(PARAMETER_SAMPLE_SIZE_LIST);
                    for (String[] pair : parameterList) {
                        absoluteNumber += Integer.valueOf(pair[1]).intValue();
                    }
                } else {
                    absoluteNumber = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                }
                if (emd.getNumberOfExamples().isAtLeast(absoluteNumber) == MetaDataInfo.NO) {
                    this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_SAMPLE_SIZE, ((Integer)emd.getNumberOfExamples().getValue()).toString())), "exampleset.need_more_examples", absoluteNumber + ""));
                }
                return new MDInteger(absoluteNumber);
            }
            case 1: {
                if (balanceData) {
                    MDInteger numberOfExamples = emd.getNumberOfExamples();
                    numberOfExamples.reduceByUnknownAmount();
                    return numberOfExamples;
                }
                if (emd.getNumberOfExamples().isKnown()) {
                    return new MDInteger((int)(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO) * (double)((Integer)emd.getNumberOfExamples().getValue()).intValue()));
                }
                return new MDInteger();
            }
            case 2: {
                if (balanceData) {
                    MDInteger numberOfExamples = emd.getNumberOfExamples();
                    numberOfExamples.reduceByUnknownAmount();
                    return numberOfExamples;
                }
                if (emd.getNumberOfExamples().isKnown()) {
                    return new MDInteger((int)(this.getParameterAsDouble(PARAMETER_SAMPLE_PROBABILITY) * (double)((Integer)emd.getNumberOfExamples().getValue()).intValue()));
                }
                return new MDInteger();
            }
        }
        return new MDInteger();
    }

    @Override
    public ExampleSet apply(ExampleSet originalSet) throws OperatorException {
        int resultSize = 0;
        int[] usedIndices = new int[originalSet.size()];
        SplittedExampleSet perLabelSets = null;
        int numberOfIterations = 1;
        boolean balanceData = this.getParameterAsBoolean(PARAMETER_BALANCE_DATA);
        Attribute label = null;
        List<String[]> pairs = null;
        ExampleSet exampleSet = null;
        if (balanceData) {
            label = originalSet.getAttributes().getLabel();
            if (label != null) {
                if (!label.isNominal()) {
                    throw new UserError((Operator)this, 105);
                }
            } else {
                throw new UserError((Operator)this, resultSize);
            }
            perLabelSets = SplittedExampleSet.splitByAttribute(originalSet, label);
            exampleSet = perLabelSets;
            switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
                case 1: {
                    pairs = this.getParameterList(PARAMETER_SAMPLE_RATIO_LIST);
                    break;
                }
                case 0: {
                    pairs = this.getParameterList(PARAMETER_SAMPLE_SIZE_LIST);
                    break;
                }
                default: {
                    pairs = this.getParameterList(PARAMETER_SAMPLE_PROBABILITY_LIST);
                }
            }
            numberOfIterations = pairs.size();
        } else {
            exampleSet = originalSet;
        }
        for (int i = 0; i < numberOfIterations; ++i) {
            SamplingSequenceGenerator sampleSequence = null;
            if (balanceData) {
                perLabelSets.clearSelection();
                perLabelSets.selectAdditionalSubset(i);
                String parameter = "0";
                if (exampleSet.size() > 0) {
                    Example next = (Example)exampleSet.iterator().next();
                    String labelValue = next.getValueAsString(label);
                    for (String[] pair : pairs) {
                        if (!labelValue.equals(pair[0])) continue;
                        parameter = pair[1];
                        break;
                    }
                }
                switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
                    case 1: {
                        sampleSequence = new RelativeSamplingSequenceGenerator(exampleSet.size(), Double.valueOf(parameter), RandomGenerator.getRandomGenerator(this));
                        break;
                    }
                    case 0: {
                        sampleSequence = new AbsoluteSamplingSequenceGenerator(exampleSet.size(), Integer.valueOf(parameter), RandomGenerator.getRandomGenerator(this));
                        break;
                    }
                    default: {
                        sampleSequence = new ProbabilitySamplingSequenceGenerator(Double.valueOf(parameter), RandomGenerator.getRandomGenerator(this));
                        break;
                    }
                }
            } else {
                switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
                    case 1: {
                        sampleSequence = new RelativeSamplingSequenceGenerator(exampleSet.size(), this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO), RandomGenerator.getRandomGenerator(this));
                        break;
                    }
                    case 0: {
                        int size = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                        if (size > exampleSet.size()) {
                            throw new UserError((Operator)this, 110, size);
                        }
                        sampleSequence = new AbsoluteSamplingSequenceGenerator(exampleSet.size(), size, RandomGenerator.getRandomGenerator(this));
                        break;
                    }
                    default: {
                        sampleSequence = new ProbabilitySamplingSequenceGenerator(this.getParameterAsDouble(PARAMETER_SAMPLE_PROBABILITY), RandomGenerator.getRandomGenerator(this));
                    }
                }
            }
            for (int j = 0; j < exampleSet.size(); ++j) {
                if (!((SamplingSequenceGenerator)sampleSequence).useNext()) continue;
                usedIndices[resultSize] = balanceData ? perLabelSets.getActualParentIndex(j) : j;
                ++resultSize;
            }
        }
        int[] resultIndices = new int[resultSize];
        System.arraycopy(usedIndices, 0, resultIndices, 0, resultSize);
        return new MappedExampleSet(originalSet, resultIndices, true, false);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeCategory(PARAMETER_SAMPLE, "Determines how the amount of data is specified.", SAMPLE_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_BALANCE_DATA, "If you need to sample differently for examples of a certain class, you might check this.", false, true);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 0));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 1));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_PROBABILITY, "The sample probability for each example.", 0.0, 1.0, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 2));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_SAMPLE_SIZE_LIST, "The absolut sample size per class.", (ParameterType)new ParameterTypeString("class", "The class name this sample size applies to."), (ParameterType)new ParameterTypeInt("size", "The number of sampled examples of this class.", 0, Integer.MAX_VALUE));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 0));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_SAMPLE_RATIO_LIST, "The fraction per class.", (ParameterType)new ParameterTypeString("class", "The class name this sample size applies to."), (ParameterType)new ParameterTypeDouble("ratio", "The fractions of examples of this class.", 0.0, 1.0));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 1));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_SAMPLE_PROBABILITY_LIST, "The fraction per class.", (ParameterType)new ParameterTypeString("class", "The class name this sample size applies to."), (ParameterType)new ParameterTypeDouble("probability", "The probability of examples of this class to belong to the sample.", 0.0, 1.0));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 2));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_BALANCE_DATA, true, true));
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), SamplingOperator.class, null);
    }
}

