/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.sampling.AbstractStratifiedSampling;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

public class RatioStratifiedSampling
extends AbstractStratifiedSampling {
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";

    public RatioStratifiedSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        MDInteger number = emd.getNumberOfExamples();
        number.multiply(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
        return number;
    }

    @Override
    public double getRatio(ExampleSet exampleSet) throws OperatorException {
        return this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        return types;
    }
}

