/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.OneToManyPassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class PartitionOperator
extends Operator {
    public static final String PARAMETER_PARTITIONS = "partitions";
    public static final String PARAMETER_RATIO = "ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPortExtender outExtender = new OutputPortExtender("partition", this.getOutputPorts());

    public PartitionOperator(OperatorDescription description) {
        super(description);
        this.outExtender.start();
        this.getTransformer().addRule(new OneToManyPassThroughRule(this.exampleSetInput, this.outExtender.getManagedPorts()){

            @Override
            public void transformMD() {
                super.transformMD();
                try {
                    String[] ratioList = ParameterTypeEnumeration.transformString2Enumeration(PartitionOperator.this.getParameterAsString(PartitionOperator.PARAMETER_PARTITIONS));
                    double[] ratios = new double[ratioList.length];
                    int i = 0;
                    double sum = 0.0;
                    for (String entry : ratioList) {
                        ratios[i] = Double.valueOf(entry);
                        sum += ratios[i];
                        ++i;
                    }
                    if (sum != 1.0) {
                        PartitionOperator.this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, PartitionOperator.this.getPortOwner(), "parameter_enumeration_forbidden_sum", PartitionOperator.PARAMETER_PARTITIONS, "1"));
                    }
                }
                catch (UndefinedParameterError e) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData, int outputIndex) {
                if (unmodifiedMetaData instanceof ExampleSetMetaData) {
                    try {
                        unmodifiedMetaData = PartitionOperator.this.modifiyMetaData((ExampleSetMetaData)unmodifiedMetaData, outputIndex);
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        // empty catch block
                    }
                }
                return unmodifiedMetaData;
            }
        });
    }

    protected ExampleSetMetaData modifiyMetaData(ExampleSetMetaData metaData, int outputIndex) throws UndefinedParameterError {
        if (metaData.getNumberOfExamples().isKnown()) {
            String[] ratioList = ParameterTypeEnumeration.transformString2Enumeration(this.getParameterAsString(PARAMETER_PARTITIONS));
            double[] ratios = new double[ratioList.length];
            if (outputIndex < ratios.length) {
                int i = 0;
                double sum = 0.0;
                for (String entry : ratioList) {
                    ratios[i] = Double.valueOf(entry);
                    sum += ratios[i];
                    ++i;
                }
                metaData.setNumberOfExamples((int)(ratios[outputIndex] / sum * (double)((Integer)metaData.getNumberOfExamples().getValue()).intValue()));
                for (AttributeMetaData amd : metaData.getAllAttributes()) {
                    amd.getNumberOfMissingValues().reduceByUnknownAmount();
                }
            } else {
                return null;
            }
        }
        return metaData;
    }

    @Override
    public void doWork() throws OperatorException {
        String[] ratioList = ParameterTypeEnumeration.transformString2Enumeration(this.getParameterAsString(PARAMETER_PARTITIONS));
        double[] ratios = new double[ratioList.length];
        int i = 0;
        double sum = 0.0;
        for (String entry : ratioList) {
            ratios[i] = Double.valueOf(entry);
            sum += ratios[i];
            ++i;
        }
        int j = 0;
        while (j < ratios.length) {
            int n = j++;
            ratios[n] = ratios[n] / sum;
        }
        ExampleSet originalSet = (ExampleSet)this.exampleSetInput.getData();
        SplittedExampleSet e = new SplittedExampleSet(originalSet, ratios, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        List outputs = this.outExtender.getManagedPorts();
        for (int j2 = 0; j2 < ratioList.length; ++j2) {
            SplittedExampleSet b = (SplittedExampleSet)e.clone();
            b.selectSingleSubset(j2);
            if (outputs.size() <= j2) continue;
            ((OutputPort)outputs.get(j2)).deliver(b);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeEnumeration(PARAMETER_PARTITIONS, "The partitions that should be created.", (ParameterType)new ParameterTypeDouble(PARAMETER_RATIO, "The relative size of this partition.", 0.0, 1.0), false));
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), PartitionOperator.class, null);
    }
}

