/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.numerical.EuclideanDistance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class KennardStoneSampling
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE = "sample";
    public static final String[] SAMPLE_MODES = new String[]{"absolute", "relative"};
    public static final int SAMPLE_ABSOLUTE = 0;
    public static final int SAMPLE_RELATIVE = 1;
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";

    public KennardStoneSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                int absoluteNumber = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                if (emd.getNumberOfExamples().isAtLeast(absoluteNumber) == MetaDataInfo.NO) {
                    this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_SAMPLE_SIZE, ((Integer)emd.getNumberOfExamples().getValue()).toString())), "need_more_examples", absoluteNumber + ""));
                }
                return new MDInteger(absoluteNumber);
            }
            case 1: {
                MDInteger number = emd.getNumberOfExamples();
                number.multiply(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
                return number;
            }
        }
        return new MDInteger();
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int k = Math.min(100, exampleSet.getAttributes().size() * 2);
        int size = exampleSet.size();
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                size = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                break;
            }
            case 1: {
                size = (int)Math.round((double)exampleSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
            }
        }
        EuclideanDistance distanceMeasure = new EuclideanDistance();
        ((DistanceMeasure)distanceMeasure).init(exampleSet);
        double[] meanVector = this.getMeanVector(exampleSet);
        Candidate min = new Candidate(meanVector, Double.POSITIVE_INFINITY, 0);
        Candidate max = new Candidate(meanVector, Double.NEGATIVE_INFINITY, 0);
        int i = 0;
        for (Example example : exampleSet) {
            double[] exampleValues = this.getExampleValues(example);
            Candidate current = new Candidate(exampleValues, Math.abs(((DistanceMeasure)distanceMeasure).calculateDistance(meanVector, exampleValues)), i);
            if (current.compareTo(min) < 0) {
                min = current;
            }
            if (current.compareTo(max) > 0) {
                max = current;
            }
            ++i;
        }
        ArrayList<Candidate> recentlySelected = new ArrayList<Candidate>(10);
        int[] partition = new int[exampleSet.size()];
        int numberOfSelectedExamples = 2;
        recentlySelected.add(min);
        recentlySelected.add(max);
        partition[min.getExampleIndex()] = 1;
        partition[max.getExampleIndex()] = 1;
        double[] minimalDistances = new double[exampleSet.size()];
        Arrays.fill(minimalDistances, Double.POSITIVE_INFINITY);
        block5: while (numberOfSelectedExamples < size) {
            TreeSet<Candidate> candidates = new TreeSet<Candidate>();
            i = 0;
            for (Example example : exampleSet) {
                if (partition[i] == 0) {
                    double[] exampleValues = this.getExampleValues(example);
                    for (Candidate candidate : recentlySelected) {
                        minimalDistances[i] = Math.min(minimalDistances[i], Math.abs(((DistanceMeasure)distanceMeasure).calculateDistance(exampleValues, candidate.getValues())));
                    }
                    Candidate newCandidate = new Candidate(exampleValues, minimalDistances[i], i);
                    candidates.add(newCandidate);
                    if (candidates.size() > k) {
                        Iterator iterator = candidates.iterator();
                        iterator.next();
                        iterator.remove();
                    }
                }
                ++i;
            }
            recentlySelected.clear();
            LinkedList reverseCandidateList = new LinkedList();
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                reverseCandidateList.add(it.next());
            }
            ListIterator lit = reverseCandidateList.listIterator(reverseCandidateList.size() - 1);
            while (lit.hasPrevious()) {
                Candidate candidate = (Candidate)lit.previous();
                boolean existSmallerDistance = false;
                Iterator addedIterator = recentlySelected.iterator();
                while (addedIterator.hasNext()) {
                    double distance = Math.abs(((DistanceMeasure)distanceMeasure).calculateDistance(((Candidate)addedIterator.next()).getValues(), candidate.getValues()));
                    existSmallerDistance = existSmallerDistance || distance < candidate.getDistance();
                }
                if (existSmallerDistance) continue block5;
                recentlySelected.add(candidate);
                partition[candidate.getExampleIndex()] = 1;
                ++numberOfSelectedExamples;
            }
        }
        SplittedExampleSet sample = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        sample.selectSingleSubset(1);
        return sample;
    }

    private double[] getMeanVector(ExampleSet exampleSet) {
        exampleSet.recalculateAllAttributeStatistics();
        Attributes attributes = exampleSet.getAttributes();
        double[] meanVector = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            meanVector[i] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9) ? exampleSet.getStatistics(attribute, "minimum") : (attribute.isNominal() ? exampleSet.getStatistics(attribute, "mode") : exampleSet.getStatistics(attribute, "average"));
            ++i;
        }
        return meanVector;
    }

    private double[] getExampleValues(Example example) {
        Attributes attributes = example.getAttributes();
        double[] attributeValues = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            attributeValues[i] = example.getValue(attribute);
            ++i;
        }
        return attributeValues;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_SAMPLE, "Determines how the amount of data is specified.", SAMPLE_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), KennardStoneSampling.class, null);
    }

    private static class Candidate
    implements Comparable<Candidate> {
        private double[] attributeValues;
        private double distance;
        private int exampleIndex;

        public Candidate(double[] exampleValues, double distance, int exampleIndex) {
            this.attributeValues = exampleValues;
            this.distance = distance;
            this.exampleIndex = exampleIndex;
        }

        public double getDistance() {
            return this.distance;
        }

        public double[] getValues() {
            return this.attributeValues;
        }

        public int getExampleIndex() {
            return this.exampleIndex;
        }

        @Override
        public int compareTo(Candidate o) {
            return Double.compare(this.distance, o.getDistance());
        }
    }
}

