/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class BootstrappingOperator
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE = "sample";
    public static final String[] SAMPLE_MODES = new String[]{"absolute", "relative"};
    public static final int SAMPLE_ABSOLUTE = 0;
    public static final int SAMPLE_RELATIVE = 1;
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_USE_WEIGHTS = "use_weights";

    public BootstrappingOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                return new MDInteger(this.getParameterAsInt(PARAMETER_SAMPLE_SIZE));
            }
            case 1: {
                MDInteger number = emd.getNumberOfExamples();
                number.multiply(this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
                return number;
            }
        }
        return new MDInteger();
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        int size = exampleSet.size();
        switch (this.getParameterAsInt(PARAMETER_SAMPLE)) {
            case 0: {
                size = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
                break;
            }
            case 1: {
                size = (int)Math.round((double)exampleSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO));
            }
        }
        int[] mapping = null;
        mapping = this.getParameterAsBoolean(PARAMETER_USE_WEIGHTS) && exampleSet.getAttributes().getWeight() != null ? MappedExampleSet.createWeightedBootstrappingMapping(exampleSet, size, random) : MappedExampleSet.createBootstrappingMapping(exampleSet, size, random);
        return new MappedExampleSet(exampleSet, mapping, true);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_SAMPLE, "Determines how the amount of data is specified.", SAMPLE_MODES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "This ratio determines the size of the new example set.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLE, SAMPLE_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_WEIGHTS, "If checked, example weights will be considered during the bootstrapping if such weights are present.", true);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), BootstrappingOperator.class, null);
    }
}

