/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractStratifiedSampling
extends AbstractSamplingOperator {
    public AbstractStratifiedSampling(OperatorDescription description) {
        super(description);
    }

    public abstract double getRatio(ExampleSet var1) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        SplittedExampleSet splittedExampleSet = new SplittedExampleSet(exampleSet, this.getRatio(exampleSet), 2, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        splittedExampleSet.selectSingleSubset(0);
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        for (Example example : splittedExampleSet) {
            dataList.add(example.getDataRow());
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(splittedExampleSet.getExampleTable().getAttributes());
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

