/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

public abstract class AbstractBootstrapping
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";

    public AbstractBootstrapping(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        if (emd.getNumberOfExamples().isKnown()) {
            return new MDInteger((int)this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO) * (Integer)emd.getNumberOfExamples().getValue());
        }
        return new MDInteger();
    }

    public abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        int[] mapping = this.createMapping(exampleSet, (int)Math.round((double)exampleSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO)), random);
        MappedExampleSet bootstrappedExampleSet = new MappedExampleSet(exampleSet, mapping, true);
        return bootstrappedExampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "This ratio determines the size of the new example set.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

