/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.sampling.AbstractStratifiedSampling;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AbsoluteStratifiedSampling
extends AbstractStratifiedSampling {
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";

    public AbsoluteStratifiedSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        int absoluteNumber = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        if (emd.getNumberOfExamples().isAtLeast(absoluteNumber) == MetaDataInfo.NO) {
            this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_SAMPLE_SIZE, ((Integer)emd.getNumberOfExamples().getValue()).toString())), "need_more_examples", absoluteNumber + ""));
        }
        return new MDInteger(absoluteNumber);
    }

    @Override
    public double getRatio(ExampleSet exampleSet) throws OperatorException {
        double targetSize = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        if (targetSize > (double)exampleSet.size()) {
            return 1.0;
        }
        return targetSize / (double)exampleSet.size();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        return types;
    }
}

