/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.Collections;
import java.util.List;

public class AbsoluteSampling
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";

    public AbsoluteSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getSampledSize(ExampleSetMetaData emd) throws UndefinedParameterError {
        int absoluteNumber = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        if (emd.getNumberOfExamples().isAtLeast(absoluteNumber) == MetaDataInfo.NO) {
            this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_SAMPLE_SIZE, ((Integer)emd.getNumberOfExamples().getValue()).toString())), "exampleset.need_more_examples", absoluteNumber + ""));
        }
        return new MDInteger(absoluteNumber);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

