/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.operator.preprocessing.outlier.KdistanceContainer;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;

public class SearchSpace {
    private int dimensions;
    private Vector<SearchObject> listOfObjects;
    private double[] minimumVectorValue;
    private double[] maximumVectorValue;
    private double[] rangeVectorValue;

    public SearchSpace(int dim) {
        this.dimensions = dim;
        this.createListOfObjects();
        this.minimumVectorValue = new double[dim];
        this.maximumVectorValue = new double[dim];
        this.rangeVectorValue = new double[dim];
        for (int i = 0; i < this.dimensions; ++i) {
            this.minimumVectorValue[i] = 0.0;
            this.maximumVectorValue[i] = 0.0;
            this.rangeVectorValue[i] = 0.0;
        }
    }

    public SearchSpace() {
        this(2);
    }

    public SearchSpace(int dim, int minptslb, int minptsub) {
        this(dim);
    }

    public int getNumberOfObjects() {
        return this.listOfObjects.size();
    }

    void setMinimumVectorValue(int dim, double value) {
        this.minimumVectorValue[dim] = value;
    }

    double getMinimumVectorValue(int dim) {
        return this.minimumVectorValue[dim];
    }

    void setMaximumVectorValue(int dim, double value) {
        this.maximumVectorValue[dim] = value;
    }

    double getMaximumVectorValue(int dim) {
        return this.maximumVectorValue[dim];
    }

    void setRangeVectorValue(int dim, double value) {
        this.rangeVectorValue[dim] = value;
    }

    double getRangeVectorValue(int dim) {
        return this.rangeVectorValue[dim];
    }

    public void setDimensions(int dim) {
        this.dimensions = dim;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    void createListOfObjects() {
        this.listOfObjects = new Vector();
    }

    public Vector<SearchObject> getSearchObjects() {
        return this.listOfObjects;
    }

    public boolean getSearchObjectOutlierStatus(int i) {
        SearchObject so = this.listOfObjects.elementAt(i);
        return so.getOutlierStatus();
    }

    public void addObject(SearchObject objectToAdd) {
        this.listOfObjects.addElement(objectToAdd);
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (this.getMinimumVectorValue(i) > objectToAdd.getVektor(i)) {
                this.setMinimumVectorValue(i, objectToAdd.getVektor(i));
            }
            if (this.getMaximumVectorValue(i) < objectToAdd.getVektor(i)) {
                this.setMaximumVectorValue(i, objectToAdd.getVektor(i));
            }
            this.setRangeVectorValue(i, this.getMaximumVectorValue(i) - this.getMinimumVectorValue(i));
        }
    }

    public SearchObject getObject(int index) {
        return this.listOfObjects.elementAt(index);
    }

    public Enumeration getObjects() {
        return this.listOfObjects.elements();
    }

    int[] dimensionsIntegrityCheck() {
        int number = this.getNumberOfObjects();
        int[] range = new int[number];
        int checker = 0;
        for (int i = 0; i < number; ++i) {
            SearchObject sobject = this.listOfObjects.elementAt(i);
            if (sobject.getDimensions() != this.dimensions) {
                if (sobject.getDimensions() < this.dimensions) {
                    range[i] = 1;
                }
                range[i] = -1;
            } else {
                range[i] = 0;
            }
            checker += range[i];
        }
        return range;
    }

    public void resetOutlierStatus() {
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            SearchObject sobject = this.listOfObjects.elementAt(i);
            sobject.setOutlierStatus(false);
            sobject.setOutlierFactor(0.0);
        }
    }

    public void radiusODSearch(double d, double p, SearchObject rObject, int kindOfDistance) {
        int number = this.getNumberOfObjects();
        long m = Math.round((double)number * (1.0 - p));
        int counter = 0;
        for (int i = 0; !(i >= number || rObject.getDistance(this.listOfObjects.elementAt(i), kindOfDistance) < d && (long)(++counter) > m); ++i) {
        }
        if ((long)counter > m) {
            rObject.setOutlierStatus(false);
        } else {
            rObject.setOutlierStatus(true);
        }
    }

    public void allRadiusSearch(double d, double p, int kindOfDistance) {
        int n = this.getNumberOfObjects();
        int segment = 10;
        for (int i = 0; i < n; ++i) {
            this.radiusODSearch(d, p, this.listOfObjects.elementAt(i), kindOfDistance);
            if (100 * i / n <= segment) continue;
            segment += 10;
        }
    }

    public double[] getAverageDistanceMeasures(int kindOfDistance) {
        double meanDistance = 0.0;
        double standardDeviationOfDistance = 0.0;
        double varianceOfDistance = 0.0;
        double distance = 0.0;
        double sumOfDistance = 0.0;
        double[] distances = new double[(this.getNumberOfObjects() * this.getNumberOfObjects() - this.getNumberOfObjects()) / 2];
        double counter = 0.0;
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            SearchObject so = this.listOfObjects.elementAt(i);
            for (int j = i; j < this.getNumberOfObjects(); ++j) {
                if (i == j) continue;
                distance = so.getDistance(this.listOfObjects.elementAt(j), kindOfDistance);
                sumOfDistance += distance;
                distances[(int)counter] = distance;
                counter += 1.0;
            }
        }
        meanDistance = sumOfDistance / counter;
        int k = 0;
        while ((double)k < counter) {
            varianceOfDistance += Math.pow(distances[k] - meanDistance, 2.0);
            ++k;
        }
        standardDeviationOfDistance = Math.sqrt(varianceOfDistance /= counter);
        double[] distMeasures = new double[]{meanDistance, varianceOfDistance, standardDeviationOfDistance};
        return distMeasures;
    }

    public double[] getAverageLOFMeasures() {
        SearchObject so;
        double meanLOF = 0.0;
        double standardDeviationOfLOF = 0.0;
        double varianceOfLOF = 0.0;
        double sumOfLOF = 0.0;
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            sumOfLOF += so.getOutlierFactor();
        }
        meanLOF = sumOfLOF / (double)this.getNumberOfObjects();
        for (int k = 0; k < this.getNumberOfObjects(); ++k) {
            so = this.listOfObjects.elementAt(k);
            varianceOfLOF += Math.pow(so.getOutlierFactor() - meanLOF, 2.0);
        }
        standardDeviationOfLOF = Math.sqrt(varianceOfLOF /= (double)this.getNumberOfObjects());
        double[] lofMeasures = new double[]{meanLOF, varianceOfLOF, standardDeviationOfLOF};
        return lofMeasures;
    }

    public double getMaximumOutlierFactor() {
        double maxOutlierFactor = 0.0;
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            SearchObject so = this.getObject(i);
            if (!(maxOutlierFactor < so.getOutlierFactor())) continue;
            maxOutlierFactor = so.getOutlierFactor();
        }
        return maxOutlierFactor;
    }

    public void findKdistanceContainers(SearchObject so, int kindOfDistance) {
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            KdistanceContainer newcontainer;
            SearchObject obj = this.listOfObjects.elementAt(i);
            if (obj == so) continue;
            double distance = so.getDistance(obj, kindOfDistance);
            ListIterator li = so.getKdContainerListIterator();
            int index = -1;
            boolean added = false;
            while (li.hasNext()) {
                KdistanceContainer container = (KdistanceContainer)li.next();
                ++index;
                if (container.getDistance() == distance) {
                    container.addObject(obj, distance);
                    added = true;
                    break;
                }
                if (!(container.getDistance() > distance)) continue;
                newcontainer = new KdistanceContainer(so);
                so.addKdContainer(index, newcontainer);
                newcontainer.addObject(obj, distance);
                added = true;
                break;
            }
            if (added) continue;
            newcontainer = new KdistanceContainer(so);
            so.addKdContainer(newcontainer);
            newcontainer.addObject(obj, distance);
        }
    }

    public void findAllKdContainers(int kindOfDistance) {
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            this.findKdistanceContainers(this.listOfObjects.elementAt(i), kindOfDistance);
        }
    }

    public void computeLOF(int kMin, int kMax) {
        KdistanceContainer container;
        ListIterator li;
        int k;
        int counter;
        int sumCardinality;
        SearchObject so;
        int i;
        for (i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            sumCardinality = 0;
            counter = -1;
            k = 1;
            li = so.getKdContainerListIterator();
            while (li.hasNext() && k <= kMax) {
                container = (KdistanceContainer)li.next();
                ++counter;
                sumCardinality += container.getNumberOfObjects();
                while (k <= sumCardinality && k <= kMax) {
                    so.setKDistance(k, container.getDistance());
                    so.setCardN(k, sumCardinality);
                    ++k;
                }
            }
        }
        for (i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            sumCardinality = 0;
            counter = -1;
            k = 1;
            double sumdistance = 0.0;
            li = so.getKdContainerListIterator();
            while (li.hasNext() && k <= kMax) {
                container = (KdistanceContainer)li.next();
                ++counter;
                sumCardinality += container.getNumberOfObjects();
                boolean calcLRD = false;
                double lrd = 0.0;
                while (k <= sumCardinality && k <= kMax) {
                    if (!calcLRD) {
                        ListIterator lobj = container.getListIterator();
                        while (lobj.hasNext()) {
                            SearchObject sobj = (SearchObject)lobj.next();
                            sumdistance += Math.max(container.getDistance(), sobj.getKDistance(k));
                        }
                        lrd = 1.0 / (sumdistance / (double)sumCardinality);
                        calcLRD = true;
                    }
                    so.setLRD(k, lrd);
                    ++k;
                }
            }
        }
        for (i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            sumCardinality = 0;
            counter = -1;
            k = 1;
            double[] sumlrdratio = new double[kMax + 1];
            for (int u = 0; u <= kMax; ++u) {
                sumlrdratio[u] = 0.0;
            }
            ListIterator li2 = so.getKdContainerListIterator();
            while (li2.hasNext() && k <= kMax) {
                KdistanceContainer container2 = (KdistanceContainer)li2.next();
                ++counter;
                sumCardinality += container2.getNumberOfObjects();
                boolean calcLOF = false;
                double lof = 0.0;
                while (k <= sumCardinality && k <= kMax) {
                    if (!calcLOF) {
                        ListIterator lobj = container2.getListIterator();
                        while (lobj.hasNext()) {
                            SearchObject sobj = (SearchObject)lobj.next();
                            for (int j = 1; j <= k; ++j) {
                                sumlrdratio[j] = sumlrdratio[j] + sobj.getLRD(j) / so.getLRD(j);
                            }
                        }
                        lof = sumlrdratio[k] / (double)sumCardinality;
                        calcLOF = true;
                    }
                    so.setLOF(k, lof);
                    if (k >= kMin && so.getOutlierFactor() <= lof) {
                        so.setOutlierFactor(lof);
                    }
                    ++k;
                }
            }
        }
    }

    public void computeDKN(int dk, int n) {
        SearchObject so;
        int i;
        Vector<SearchObject> listofDKNcandidates = new Vector<SearchObject>();
        int minDKNdistindex = 0;
        double minD = 0.0;
        int kMax = dk;
        double minDistInList = 0.0;
        for (i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            int sumCardinality = 0;
            int counter = -1;
            int k = 1;
            ListIterator li = so.getKdContainerListIterator();
            while (li.hasNext() && k <= kMax) {
                KdistanceContainer container = (KdistanceContainer)li.next();
                ++counter;
                sumCardinality += container.getNumberOfObjects();
                while (k <= sumCardinality && k <= kMax) {
                    so.setKDistance(k, container.getDistance());
                    so.setCardN(k, sumCardinality);
                    ++k;
                }
            }
        }
        for (i = 0; i < this.getNumberOfObjects(); ++i) {
            so = this.listOfObjects.elementAt(i);
            if (listofDKNcandidates.size() == 0) {
                listofDKNcandidates.add(so);
            } else if (listofDKNcandidates.size() <= n + 1) {
                listofDKNcandidates.add(so);
            } else if (so.getKDistance(dk) > minDistInList) {
                listofDKNcandidates.remove(minDKNdistindex);
                listofDKNcandidates.add(so);
            }
            for (int j = 0; j < listofDKNcandidates.size(); ++j) {
                SearchObject sobj = (SearchObject)listofDKNcandidates.elementAt(j);
                minD = sobj.getKDistance(dk);
                if (j == 0) {
                    minDistInList = minD;
                    minDKNdistindex = j;
                    continue;
                }
                if (!(minDistInList > minD)) continue;
                minDistInList = minD;
                minDKNdistindex = j;
            }
        }
        for (int z = 0; z < listofDKNcandidates.size(); ++z) {
            SearchObject sobj2 = (SearchObject)listofDKNcandidates.elementAt(z);
            sobj2.setOutlierStatus(true);
        }
    }
}

