/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.operator.preprocessing.outlier.KdistanceContainer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SearchObject {
    private int dimensions;
    private double[] vector;
    private boolean outlierStatus;
    private double outlierFactor;
    private String label;
    private List<KdistanceContainer> listOfkDContainers;
    private double[] kDistance;
    private double[] lrd;
    private int[] cardN;
    private double[] localOutlierFactor;
    private int minPtsUpperBound;

    public SearchObject(int dim, String l) {
        this.dimensions = dim;
        this.vector = new double[this.dimensions];
        for (int i = 0; i < dim; ++i) {
            this.vector[i] = 0.0;
        }
        this.setOutlierStatus(false);
        this.setOutlierFactor(0.0);
        this.label = l;
        this.listOfkDContainers = new LinkedList<KdistanceContainer>();
    }

    public SearchObject() {
        this(2, "not labeled object");
    }

    public SearchObject(int dim, String l, int minptslb, int minptsub) {
        this(dim, l);
        this.cardN = new int[minptsub + 1];
        this.kDistance = new double[minptsub + 1];
        this.lrd = new double[minptsub + 1];
        this.localOutlierFactor = new double[minptsub + 1];
        this.minPtsUpperBound = minptsub;
        for (int i = 0; i < this.minPtsUpperBound + 1; ++i) {
            this.cardN[i] = 0;
            this.kDistance[i] = 0.0;
            this.lrd[i] = 0.0;
            this.localOutlierFactor[i] = 0.0;
        }
    }

    public void setDimensions(int dim) {
        double[] changeVektor = new double[this.dimensions];
        int oldDimensions = this.dimensions;
        this.dimensions = dim;
        for (int j = 0; j < oldDimensions; ++j) {
            changeVektor[j] = this.vector[j];
        }
        this.vector = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            this.vector[i] = i < oldDimensions ? changeVektor[i] : 0.0;
        }
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public void setVektor(int dim, double value) {
        this.vector[dim] = value;
    }

    public double getVektor(int dim) {
        return this.vector[dim];
    }

    public void setOutlierStatus(boolean status) {
        this.outlierStatus = status;
    }

    public boolean getOutlierStatus() {
        return this.outlierStatus;
    }

    public void setOutlierFactor(double factor) {
        this.outlierFactor = factor;
    }

    public double getOutlierFactor() {
        return this.outlierFactor;
    }

    public double getDistanceEuclidian(SearchObject toObject) {
        double distance = 0.0;
        int dim_of_toObject = toObject.getDimensions();
        int minimumDimensions = 0;
        minimumDimensions = Math.min(this.dimensions, dim_of_toObject);
        for (int i = 0; i < minimumDimensions; ++i) {
            distance += Math.pow(this.getVektor(i) - toObject.getVektor(i), 2.0);
        }
        return Math.sqrt(distance);
    }

    public double getDistance(SearchObject toObject, int kindOfDistance) {
        double distance = 0.0;
        int SQUARED = 1;
        int EUCLIDIAN = 0;
        int COSINE = 2;
        int INV_COSINE = 3;
        int ANGLE_RADIANT = 4;
        if (kindOfDistance != COSINE && kindOfDistance != SQUARED && kindOfDistance != INV_COSINE && kindOfDistance != ANGLE_RADIANT && kindOfDistance != EUCLIDIAN) {
            kindOfDistance = EUCLIDIAN;
        }
        int dim_of_toObject = toObject.getDimensions();
        int minimumDimensions = 0;
        minimumDimensions = Math.min(this.dimensions, dim_of_toObject);
        if (kindOfDistance == EUCLIDIAN || kindOfDistance == SQUARED) {
            for (int i = 0; i < minimumDimensions; ++i) {
                distance += Math.pow(this.getVektor(i) - toObject.getVektor(i), 2.0);
            }
            return kindOfDistance == SQUARED ? distance : Math.sqrt(distance);
        }
        double sumOfProductsxiyi = 0.0;
        double sumxisquared = 0.0;
        double sumyisquared = 0.0;
        for (int i = 0; i < minimumDimensions; ++i) {
            sumOfProductsxiyi += this.getVektor(i) * toObject.getVektor(i);
            sumxisquared += Math.pow(this.getVektor(i), 2.0);
            sumyisquared += Math.pow(toObject.getVektor(i), 2.0);
        }
        distance = sumOfProductsxiyi / (Math.sqrt(sumxisquared) * Math.sqrt(sumyisquared));
        if (kindOfDistance == COSINE) {
            return distance;
        }
        if (kindOfDistance == INV_COSINE) {
            return 1.0 - distance;
        }
        return Math.acos(distance);
    }

    public void addKdContainer(int index) {
        KdistanceContainer container = new KdistanceContainer(this);
        this.listOfkDContainers.add(index, container);
    }

    public void addKdContainer(int index, double dist) {
        KdistanceContainer container = new KdistanceContainer(this);
        container.setDistance(dist);
        this.listOfkDContainers.add(index, container);
    }

    public void addKdContainer(int index, KdistanceContainer kd) {
        this.listOfkDContainers.add(index, kd);
    }

    public void addKdContainer(KdistanceContainer kd) {
        this.listOfkDContainers.add(kd);
    }

    public void addKdContainer() {
        KdistanceContainer container = new KdistanceContainer(this);
        this.listOfkDContainers.add(container);
    }

    public ListIterator getKdContainerListIterator() {
        ListIterator<KdistanceContainer> li = this.listOfkDContainers.listIterator();
        return li;
    }

    public void setKDistance(int k, double dist) {
        this.kDistance[k] = dist;
    }

    public double getKDistance(int k) {
        return this.kDistance[k];
    }

    public void setLRD(int k, double lrdvalue) {
        this.lrd[k] = lrdvalue;
    }

    public double getLRD(int k) {
        return this.lrd[k];
    }

    public void setCardN(int k, int card) {
        this.cardN[k] = card;
    }

    public int getCardN(int k) {
        return this.cardN[k];
    }

    public void setLOF(int k, double lof) {
        this.localOutlierFactor[k] = lof;
    }

    public double getLOF(int k) {
        return this.localOutlierFactor[k];
    }
}

