/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.operator.preprocessing.outlier.SearchSpace;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LOFOutlierOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_MINIMAL_POINTS_LOWER_BOUND = "minimal_points_lower_bound";
    public static final String PARAMETER_MINIMAL_POINTS_UPPER_BOUND = "minimal_points_upper_bound";
    public static final String PARAMETER_DISTANCE_FUNCTION = "distance_function";
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public LOFOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        int minPtsLowerBound = 0;
        int minPtsUpperBound = 0;
        int minPtsLB = this.getParameterAsInt(PARAMETER_MINIMAL_POINTS_LOWER_BOUND);
        int minPtsUB = this.getParameterAsInt(PARAMETER_MINIMAL_POINTS_UPPER_BOUND);
        int kindOfDistance = this.getParameterAsInt(PARAMETER_DISTANCE_FUNCTION);
        if (minPtsLB <= minPtsUB) {
            minPtsLowerBound = minPtsLB;
            minPtsUpperBound = minPtsUB;
        } else {
            minPtsLowerBound = minPtsUB;
            minPtsUpperBound = minPtsLB;
        }
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension, minPtsLowerBound, minPtsUpperBound + 1);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter, minPtsLowerBound, minPtsUpperBound);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        sr.resetOutlierStatus();
        sr.findAllKdContainers(kindOfDistance);
        sr.computeLOF(minPtsLowerBound, minPtsUpperBound);
        Attribute outlierAttribute = AttributeFactory.createAttribute("outlier", 4);
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            SearchObject sobj = sr.getSearchObjects().elementAt(counter);
            example.setValue(outlierAttribute, sobj.getOutlierFactor());
            ++counter;
        }
        return eSet;
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        AttributeMetaData amd = new AttributeMetaData("outlier", 4, "outlier");
        amd.setValueRange(new Range(0.0, 1.0), SetRelation.EQUAL);
        metaData.addAttribute(amd);
        return metaData;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_MINIMAL_POINTS_LOWER_BOUND, "The lower bound for MinPts for the Outlier test (default value is 10)", 0, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MINIMAL_POINTS_UPPER_BOUND, "The upper bound for MinPts for the Outlier test (default value is 20)", 0, Integer.MAX_VALUE, 20);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DISTANCE_FUNCTION, "choose which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    protected Set<String> getOutlierValues() {
        HashSet<String> set = new HashSet<String>();
        set.add("true");
        set.add("false");
        return set;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), LOFOutlierOperator.class, null);
    }
}

