/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class KdistanceContainer {
    private double distance;
    private int numberOfObjects;
    private List<SearchObject> listOfObjects = new LinkedList<SearchObject>();

    public KdistanceContainer(SearchObject so) {
        this.setDistance(0.0);
        this.setNumberOfObjects(0);
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double dist) {
        this.distance = dist;
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    private void setNumberOfObjects(int number) {
        this.numberOfObjects = number;
    }

    public boolean addObject(SearchObject so, double dist) {
        if (this.listOfObjects.size() == 0) {
            this.listOfObjects.add(so);
            this.setDistance(dist);
            this.setNumberOfObjects(this.listOfObjects.size());
            return true;
        }
        if (Tools.isEqual(this.getDistance(), dist)) {
            this.listOfObjects.add(so);
            this.setDistance(dist);
            this.setNumberOfObjects(this.listOfObjects.size());
            return true;
        }
        return false;
    }

    public SearchObject getObject(int i) {
        ListIterator<SearchObject> li = this.listOfObjects.listIterator(i);
        return li.next();
    }

    public ListIterator getListIterator() {
        ListIterator<SearchObject> li = this.listOfObjects.listIterator();
        return li;
    }
}

