/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.COFObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;

public class EcodbOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_NUMBER_OF_NEIGHBORS = "number_of_neighbors";
    public static final String PARAMETER_NUMBER_OF_Class_OUTLIERS = "number_of_class_outliers";

    public EcodbOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_NUMBER_OF_NEIGHBORS);
        int n = this.getParameterAsInt(PARAMETER_NUMBER_OF_Class_OUTLIERS);
        DistanceMeasure measure = DistanceMeasures.createMeasure(this);
        measure.init(eSet);
        if (eSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        if (!eSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, eSet.getName(), eSet.getAttributes().getLabel().getName());
        }
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 6);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        Attribute COFoutlierAttribute = AttributeFactory.createAttribute("COF Factor", 4);
        eSet.getExampleTable().addAttribute(COFoutlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        eSet.getAttributes().setSpecialAttribute(COFoutlierAttribute, "COF Factor");
        for (Example example : eSet) {
            example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            example.setValue(COFoutlierAttribute, Double.POSITIVE_INFINITY);
        }
        Attributes attributes = eSet.getAttributes();
        ArrayList<String> sampleAttributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            sampleAttributeNames.add(attribute.getName());
        }
        ArrayList<Attribute> sampleAttributes = new ArrayList<Attribute>(sampleAttributeNames.size());
        for (String attributeName : sampleAttributeNames) {
            sampleAttributes.add(attributes.get(attributeName));
        }
        ArrayList<COFObject> cofobjectList = new ArrayList<COFObject>();
        int counter = 0;
        for (Example example : eSet) {
            double[] values = new double[sampleAttributes.size()];
            int i = 0;
            for (Attribute attribute : sampleAttributes) {
                values[i] = example.getValue(attribute);
                ++i;
            }
            double label = example.getLabel();
            cofobjectList.add(new COFObject(values, label, Double.POSITIVE_INFINITY, counter++));
        }
        double maxkDist = Double.NEGATIVE_INFINITY;
        double minkDist = Double.POSITIVE_INFINITY;
        double maxDev = Double.NEGATIVE_INFINITY;
        double minDev = Double.POSITIVE_INFINITY;
        for (COFObject cofobject : cofobjectList) {
            double tempDev;
            cofobject.computeCOF(cofobjectList, k, measure);
            double tempKdist = cofobject.getKDist();
            if (tempKdist > maxkDist) {
                maxkDist = tempKdist;
            }
            if (tempKdist < minkDist) {
                minkDist = tempKdist;
            }
            if ((tempDev = cofobject.getDeviation()) > maxDev) {
                maxDev = tempDev;
            }
            if (!(tempDev < minDev)) continue;
            minDev = tempDev;
        }
        PriorityQueue<COFObject> topCOFList = new PriorityQueue<COFObject>();
        for (COFObject cofobject : cofobjectList) {
            double cof = cofobject.getCOF();
            if (topCOFList.size() < n) {
                topCOFList.offer(cofobject);
                continue;
            }
            if (!(cof < ((COFObject)topCOFList.peek()).getCOF())) continue;
            topCOFList.remove();
            topCOFList.offer(cofobject);
        }
        for (COFObject cofobject : topCOFList) {
            cofobject.recomputeCOF(minDev, maxDev, minkDist, maxkDist);
        }
        for (COFObject cofobject : topCOFList) {
            Example example = eSet.getExample(cofobject.getId());
            example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            example.setValue(COFoutlierAttribute, cofobject.getCOF());
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_NEIGHBORS, "Specifies the k value for the k-th nearest neighbours to be the analyzed. (default value is 10, minimum 1 and max is set to 1 million)", 1, Integer.MAX_VALUE, 7, false));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_Class_OUTLIERS, "The number of top-n Class Outliers to be looked for.(default value is 10, minimum 2 (internal reasons) and max is set to 1 million)", 1, Integer.MAX_VALUE, 10, false));
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }

    @Override
    protected Set<String> getOutlierValues() {
        HashSet<String> set = new HashSet<String>();
        set.add("true");
        set.add("false");
        return set;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), EcodbOperator.class, null);
    }
}

