/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.operator.preprocessing.outlier.SearchSpace;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DBOutlierOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_DISTANCE = "distance";
    public static final String PARAMETER_PROPORTION = "proportion";
    public static final String PARAMETER_DISTANCE_FUNCTION = "distance_function";
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public DBOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        double d = this.getParameterAsDouble(PARAMETER_DISTANCE);
        double p = this.getParameterAsDouble(PARAMETER_PROPORTION);
        int kindOfDistance = this.getParameterAsInt(PARAMETER_DISTANCE_FUNCTION);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        this.log("Searching d=" + sr.getDimensions() + " dimensions with D=" + d + " distance and p=" + p + " .");
        sr.resetOutlierStatus();
        sr.allRadiusSearch(d, p, kindOfDistance);
        Attribute outlierAttribute = AttributeFactory.createAttribute("outlier", 6);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            if (sr.getSearchObjectOutlierStatus(counter)) {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            } else {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            }
            ++counter;
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_DISTANCE, "The distance for objects.", 0.0, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_PROPORTION, "The proportion of objects related to D.", 0.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_DISTANCE_FUNCTION, "Indicates which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0, false));
        return types;
    }

    @Override
    protected Set<String> getOutlierValues() {
        HashSet<String> set = new HashSet<String>();
        set.add("true");
        set.add("false");
        return set;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), DBOutlierOperator.class, null);
    }
}

