/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.operator.preprocessing.outlier.COFKnn;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class COFObject
implements Comparable<COFObject> {
    double[] values;
    double cof;
    int id;
    double pcl;
    double deviation;
    double kDist;
    double label;

    public COFObject() {
        this.cof = Double.POSITIVE_INFINITY;
        this.id = -1;
    }

    public COFObject(double[] vals, double label, double cof, int id) {
        this.cof = cof;
        this.id = id;
        this.values = vals;
        this.label = label;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public double getValMember(int dim) {
        return this.values[dim];
    }

    public int getDimensions() {
        return this.values.length;
    }

    public double getCOF() {
        return this.cof;
    }

    public void setCOF(double cof) {
        this.cof = cof;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public void setDeviation(double deviation) {
        this.deviation = deviation;
    }

    public double getKDist() {
        return this.kDist;
    }

    public void setKDist(double dist) {
        this.kDist = dist;
    }

    public double getLabel() {
        return this.label;
    }

    public void setLabel(double label) {
        this.label = label;
    }

    public double getPcl() {
        return this.pcl;
    }

    public void setPcl(double pcl) {
        this.pcl = pcl;
    }

    @Override
    public int compareTo(COFObject arg0) {
        if (this.cof < arg0.getCOF()) {
            return 1;
        }
        if (this.cof > arg0.getCOF()) {
            return -1;
        }
        return 0;
    }

    public void recomputeCOF(double minDev, double maxDev, double minkDist, double maxkDist) {
        this.cof = this.pcl - (this.deviation - minDev) / (maxDev - minDev) + (this.kDist - minkDist) / (maxkDist - minkDist);
    }

    public void computeCOF(ArrayList<COFObject> cofobjectList, int k, DistanceMeasure measure) {
        PriorityQueue<COFKnn> knnList = new PriorityQueue<COFKnn>();
        double pcl = 0.0;
        double kDist = 0.0;
        double deviation = 0.0;
        for (COFObject cofobject : cofobjectList) {
            double distance = Double.POSITIVE_INFINITY;
            distance = measure.calculateDistance(this.getValues(), cofobject.getValues());
            COFKnn cOFKnn = new COFKnn(cofobject, distance);
            if (knnList.size() < k) {
                knnList.offer(cOFKnn);
            } else if (distance < ((COFKnn)knnList.peek()).getDistance()) {
                knnList.remove();
                knnList.offer(cOFKnn);
            }
            if (this.getLabel() != cofobject.getLabel()) continue;
            deviation += distance;
        }
        this.setDeviation(deviation);
        for (COFKnn cofKnn : knnList) {
            kDist += measure.calculateDistance(this.getValues(), cofKnn.getCofobject().getValues());
            if (this.getLabel() != cofKnn.getCofobject().getLabel()) continue;
            pcl += 1.0;
        }
        this.setPcl(pcl);
        this.setCOF(pcl);
        this.setKDist(kDist);
    }
}

