/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.ZTransformationModel;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ZTransformationNormalizationMethod
extends AbstractNormalizationMethod {
    @Override
    public Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd, InputPort exampleSetInputPort, ParameterHandler parameterHandler) throws UndefinedParameterError {
        amd.setMean(new MDReal(0.0));
        amd.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
        return Collections.singleton(amd);
    }

    @Override
    public AbstractNormalizationModel getNormalizationModel(ExampleSet exampleSet, Operator operator) throws UserError {
        exampleSet.recalculateAllAttributeStatistics();
        HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap = new HashMap<String, Tupel<Double, Double>>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            attributeMeanVarianceMap.put(attribute.getName(), new Tupel<Double, Double>(exampleSet.getStatistics(attribute, "average"), exampleSet.getStatistics(attribute, "variance")));
        }
        ZTransformationModel model = new ZTransformationModel(exampleSet, attributeMeanVarianceMap);
        return model;
    }

    @Override
    public String getName() {
        return "Z-transformation";
    }
}

