/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.Iterator;

public class ZTransformationModel
extends AbstractNormalizationModel {
    private static final long serialVersionUID = 7739929307307501706L;
    private HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap;

    public ZTransformationModel(ExampleSet exampleSet, HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap) {
        super(exampleSet);
        this.attributeMeanVarianceMap = attributeMeanVarianceMap;
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeMeanVarianceMap.containsKey(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Tupel<Double, Double> meanVarianceTupel = this.attributeMeanVarianceMap.get(targetAttribute.getName());
        if (meanVarianceTupel != null) {
            if (meanVarianceTupel.getSecond() <= 0.0) {
                return 0.0;
            }
            return (value - meanVarianceTupel.getFirst()) / Math.sqrt(meanVarianceTupel.getSecond());
        }
        return value;
    }

    @Override
    public String getName() {
        return "Z-Transformation";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Normalize " + this.attributeMeanVarianceMap.size() + " attributes to mean 0 and variance 1." + Tools.getLineSeparator() + "Using");
        int counter = 0;
        for (String name : this.attributeMeanVarianceMap.keySet()) {
            if (counter > 4) {
                result.append(Tools.getLineSeparator() + "... " + (this.attributeMeanVarianceMap.size() - 5) + " more attributes ...");
                break;
            }
            Tupel<Double, Double> meanVariance = this.attributeMeanVarianceMap.get(name);
            result.append(Tools.getLineSeparator() + name + " --> mean: " + meanVariance.getFirst() + ", variance: " + meanVariance.getSecond());
            ++counter;
        }
        return result.toString();
    }
}

