/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.MinMaxNormalizationModel;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RangeNormalizationMethod
extends AbstractNormalizationMethod {
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    @Override
    public Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd, InputPort exampleSetInputPort, ParameterHandler parameterHandler) throws UndefinedParameterError {
        double min = parameterHandler.getParameterAsDouble(PARAMETER_MIN);
        double max = parameterHandler.getParameterAsDouble(PARAMETER_MAX);
        amd.setMean(new MDReal());
        amd.setValueRange(new Range(min, max), SetRelation.EQUAL);
        return Collections.singleton(amd);
    }

    @Override
    public AbstractNormalizationModel getNormalizationModel(ExampleSet exampleSet, Operator operator) throws UserError {
        double min = operator.getParameterAsDouble(PARAMETER_MIN);
        double max = operator.getParameterAsDouble(PARAMETER_MAX);
        if (max <= min) {
            throw new UserError(operator, 116, PARAMETER_MAX, "Must be greater than 'min'");
        }
        HashMap<String, Tupel<Double, Double>> attributeRanges = new HashMap<String, Tupel<Double, Double>>();
        exampleSet.recalculateAllAttributeStatistics();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            attributeRanges.put(attribute.getName(), new Tupel<Double, Double>(exampleSet.getStatistics(attribute, "minimum"), exampleSet.getStatistics(attribute, "maximum")));
        }
        return new MinMaxNormalizationModel(exampleSet, min, max, attributeRanges);
    }

    @Override
    public String getName() {
        return "range transformation";
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler handler) {
        List<ParameterType> types = super.getParameterTypes(handler);
        types.add(new ParameterTypeDouble(PARAMETER_MIN, "The minimum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_MAX, "The maximum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

