/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProportionNormalizationModel
extends AbstractNormalizationModel {
    private static final long serialVersionUID = 5620317015578777169L;
    private HashMap<String, Double> attributeSums;
    private Set<String> attributeNames;

    public ProportionNormalizationModel(ExampleSet exampleSet, HashMap<String, Double> attributeSums) {
        super(exampleSet);
        this.attributeSums = attributeSums;
        this.attributeNames = new HashSet<String>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            this.attributeNames.add(attribute.getName());
        }
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeNames.contains(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Double sum = this.attributeSums.get(targetAttribute.getName());
        return value / sum;
    }

    @Override
    public String getName() {
        return "Proportional normalization model";
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Normalizes all attributes proportional to their respective total sum. Attributes sums: \n");
        for (Map.Entry<String, Double> entry : this.attributeSums.entrySet()) {
            buffer.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return buffer.toString();
    }
}

