/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.ProportionNormalizationModel;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.container.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ProportionNormalizationMethod
extends AbstractNormalizationMethod {
    @Override
    public Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd, InputPort exampleSetInputPort, ParameterHandler parameterHandler) throws UndefinedParameterError {
        if (amd.getValueSetRelation() == SetRelation.EQUAL) {
            if (emd.getNumberOfExamples().isKnown()) {
                amd.setMean(new MDReal(1.0 / (double)((Integer)emd.getNumberOfExamples().getValue()).intValue()));
            } else {
                amd.setMean(new MDReal());
            }
            Range range = amd.getValueRange();
            if (range.getLower() < 0.0) {
                exampleSetInputPort.addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)exampleSetInputPort, "attribute_contains_negative_values", amd.getName(), this.getName()));
            }
        } else {
            amd.setMean(new MDReal());
            amd.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.UNKNOWN);
        }
        return Collections.singleton(amd);
    }

    @Override
    public AbstractNormalizationModel getNormalizationModel(ExampleSet exampleSet, Operator operator) {
        Attributes attributes = exampleSet.getAttributes();
        double[] attributeSum = new double[attributes.size()];
        for (Example example : exampleSet) {
            int i = 0;
            for (Attribute attribute : attributes) {
                if (attribute.isNumerical()) {
                    int n = i;
                    attributeSum[n] = attributeSum[n] + example.getValue(attribute);
                }
                ++i;
            }
        }
        HashMap<String, Double> attributeSums = new HashMap<String, Double>();
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNumerical()) {
                attributeSums.put(attribute.getName(), attributeSum[i]);
            }
            ++i;
        }
        return new ProportionNormalizationModel(exampleSet, attributeSums);
    }

    @Override
    public String getName() {
        return "proportion transformation";
    }
}

