/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.IQRNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.NormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.ProportionNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.RangeNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.ZTransformationNormalizationMethod;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Normalization
extends PreprocessingOperator {
    private static final ArrayList<NormalizationMethod> METHODS = new ArrayList();
    public static String[] NORMALIZATION_METHODS;
    public static final int METHOD_Z_TRANSFORMATION = 0;
    public static final int METHOD_RANGE_TRANSFORMATION = 1;
    public static final int METHOD_PROPORTION_TRANSFORMATION = 2;
    public static final String PARAMETER_NORMALIZATION_METHOD = "method";

    public Normalization(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        if (amd.isNumerical()) {
            amd.setType(4);
            int method = this.getParameterAsInt(PARAMETER_NORMALIZATION_METHOD);
            NormalizationMethod normalizationMethod = METHODS.get(method);
            return normalizationMethod.modifyAttributeMetaData(emd, amd, this.getExampleSetInputPort(), this);
        }
        return Collections.singleton(amd);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        int method = this.getParameterAsInt(PARAMETER_NORMALIZATION_METHOD);
        NormalizationMethod normalizationMethod = METHODS.get(method);
        normalizationMethod.init();
        return normalizationMethod.getNormalizationModel(exampleSet, this);
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return AbstractNormalizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_NORMALIZATION_METHOD, "Select the normalization method.", NORMALIZATION_METHODS, 0));
        int i = 0;
        for (NormalizationMethod method : METHODS) {
            for (ParameterType type : method.getParameterTypes(this)) {
                type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_NORMALIZATION_METHOD, NORMALIZATION_METHODS, true, i));
                types.add(type);
            }
            ++i;
        }
        return types;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{2};
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Normalization.class, this.attributeSelector);
    }

    public static void registerNormalizationMethod(NormalizationMethod newMethod) {
        METHODS.add(newMethod);
        NORMALIZATION_METHODS = new String[METHODS.size()];
        int i = 0;
        for (NormalizationMethod method : METHODS) {
            Normalization.NORMALIZATION_METHODS[i] = method.getName();
            ++i;
        }
    }

    static {
        Normalization.registerNormalizationMethod(new ZTransformationNormalizationMethod());
        Normalization.registerNormalizationMethod(new RangeNormalizationMethod());
        Normalization.registerNormalizationMethod(new ProportionNormalizationMethod());
        Normalization.registerNormalizationMethod(new IQRNormalizationMethod());
    }
}

