/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MinMaxNormalizationModel
extends AbstractNormalizationModel {
    private static final long serialVersionUID = 5620317015578777169L;
    private final double min;
    private final double max;
    private final HashMap<String, Tupel<Double, Double>> attributeRanges;
    private final Set<String> attributeNames;

    public MinMaxNormalizationModel(ExampleSet exampleSet, double min, double max, HashMap<String, Tupel<Double, Double>> attributeRanges) {
        super(exampleSet);
        this.min = min;
        this.max = max;
        this.attributeRanges = attributeRanges;
        this.attributeNames = new HashSet<String>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            this.attributeNames.add(attribute.getName());
        }
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeNames.contains(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Tupel<Double, Double> ranges = this.attributeRanges.get(targetAttribute.getName());
        double minA = ranges.getFirst();
        double maxA = ranges.getSecond();
        if (maxA == minA || this.min == this.max) {
            return Math.min(Math.max(minA, this.min), this.max);
        }
        return (value - minA) / (maxA - minA) * (this.max - this.min) + this.min;
    }

    @Override
    public String getName() {
        return "MinMaxNormalizationModel";
    }

    @Override
    public String toString() {
        return "Normalize between " + this.min + " and " + this.max;
    }
}

