/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.Iterator;

public class IQRNormalizationModel
extends AbstractNormalizationModel {
    private static final long serialVersionUID = 4333931155320624490L;
    private HashMap<String, Tupel<Double, Double>> attributeMeanSigmaMap;

    public IQRNormalizationModel(ExampleSet exampleSet, HashMap<String, Tupel<Double, Double>> attributeMeanSigmaMap) {
        super(exampleSet);
        this.attributeMeanSigmaMap = attributeMeanSigmaMap;
    }

    @Override
    public String getName() {
        return "IQR-Transformation";
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeMeanSigmaMap.containsKey(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Tupel<Double, Double> meanSigmaTupel = this.attributeMeanSigmaMap.get(targetAttribute.getName());
        if (meanSigmaTupel != null) {
            if (meanSigmaTupel.getSecond() <= 0.0) {
                return 0.0;
            }
            return (value - meanSigmaTupel.getFirst()) / meanSigmaTupel.getSecond();
        }
        return value;
    }
}

