/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationMethod;
import com.rapidminer.operator.preprocessing.normalization.AbstractNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.IQRNormalizationModel;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.Range;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class IQRNormalizationMethod
extends AbstractNormalizationMethod {
    @Override
    public Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd, InputPort exampleSetInputPort, ParameterHandler parameterHandler) throws UndefinedParameterError {
        amd.setMean(new MDReal(0.0));
        amd.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
        return Collections.singleton(amd);
    }

    @Override
    public AbstractNormalizationModel getNormalizationModel(ExampleSet exampleSet, Operator operator) throws UserError {
        IQRNormalizationModel model = new IQRNormalizationModel(exampleSet, this.calculateMeanSigma(exampleSet));
        return model;
    }

    private HashMap<String, Tupel<Double, Double>> calculateMeanSigma(ExampleSet exampleSet) {
        HashMap<String, Tupel<Double, Double>> attributeMeanSigmaMap = new HashMap<String, Tupel<Double, Double>>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            double[] values = new double[exampleSet.size()];
            int i = 0;
            for (Example example : exampleSet) {
                values[i++] = example.getValue(attribute);
            }
            Arrays.sort(values);
            int lowerQuart = (int)((double)(values.length + 1) * 0.25 - 1.0);
            int upperQuart = (int)((double)(values.length + 1) * 0.75 - 1.0);
            double iqSigma = (values[upperQuart] - values[lowerQuart]) / 1.349;
            double median = 0.0;
            if (0 == exampleSet.size() % 2) {
                if (exampleSet.size() > 1) {
                    median = (values[exampleSet.size() / 2] + values[exampleSet.size() / 2 - 1]) / 2.0;
                }
            } else {
                median = values[exampleSet.size() / 2];
            }
            attributeMeanSigmaMap.put(attribute.getName(), new Tupel<Double, Double>(median, iqSigma));
        }
        return attributeMeanSigmaMap;
    }

    @Override
    public String getName() {
        return "interquartile range";
    }
}

