/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;

public abstract class AbstractNormalizationModel
extends PreprocessingModel {
    private static final long serialVersionUID = 9003091723155805502L;

    protected AbstractNormalizationModel(ExampleSet exampleSet) {
        super(exampleSet);
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        Attribute[] oldAttributes = new Attribute[attributes.size()];
        int i = 0;
        Iterator<Attribute> i$ = attributes.iterator();
        while (i$.hasNext()) {
            Attribute attribute;
            oldAttributes[i] = attribute = i$.next();
            ++i;
        }
        Attribute[] newAttributes = new Attribute[attributes.size()];
        for (i = 0; i < newAttributes.length; ++i) {
            newAttributes[i] = oldAttributes[i];
            if (!oldAttributes[i].isNumerical() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttributes[i].getValueType(), 4)) continue;
            newAttributes[i] = AttributeFactory.createAttribute(4);
            exampleSet.getExampleTable().addAttribute(newAttributes[i]);
            attributes.addRegular(newAttributes[i]);
        }
        this.applyOnData(exampleSet, oldAttributes, newAttributes);
        for (i = 0; i < oldAttributes.length; ++i) {
            attributes.remove(oldAttributes[i]);
            if (oldAttributes[i] != newAttributes[i]) {
                attributes.remove(newAttributes[i]);
            }
            attributes.addRegular(newAttributes[i]);
            newAttributes[i].setName(oldAttributes[i].getName());
        }
        return exampleSet;
    }

    protected void applyOnData(ExampleSet exampleSet, Attribute[] oldAttributes, Attribute[] newAttributes) {
        for (Example example : exampleSet) {
            for (int i = 0; i < oldAttributes.length; ++i) {
                if (!oldAttributes[i].isNumerical()) continue;
                example.setValue(newAttributes[i], this.computeValue(oldAttributes[i], example.getValue(oldAttributes[i])));
            }
        }
    }

    public double computeValue(Attribute attribute, double oldValue) {
        return this.getValue(attribute, oldValue);
    }
}

