/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetUnionRule;
import com.rapidminer.operator.preprocessing.join.ExampleSetMerge;
import com.rapidminer.operator.preprocessing.join.ExampleSetSuperset;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.OperatorService;
import java.util.Arrays;

public class ExampleSetUnion
extends Operator {
    private InputPort exampleSet1Input = this.getInputPorts().createPort("example set 1", ExampleSet.class);
    private InputPort exampleSet2Input = this.getInputPorts().createPort("example set 2", ExampleSet.class);
    private OutputPort unionOutput = (OutputPort)this.getOutputPorts().createPort("union");

    public ExampleSetUnion(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetUnionRule(this.exampleSet1Input, this.exampleSet2Input, this.unionOutput, null));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet1 = (ExampleSet)this.exampleSet1Input.getData();
        ExampleSet exampleSet2 = (ExampleSet)this.exampleSet2Input.getData();
        try {
            ExampleSetSuperset supersetOperator = OperatorService.createOperator(ExampleSetSuperset.class);
            ExampleSetMerge mergeOperator = OperatorService.createOperator(ExampleSetMerge.class);
            supersetOperator.superset(exampleSet1, exampleSet2);
            this.unionOutput.deliver(mergeOperator.merge(Arrays.asList(exampleSet1, exampleSet2)));
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "inner operator", e.getMessage());
        }
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), ExampleSetUnion.class, null);
    }
}

