/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetUnionRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedList;

public class ExampleSetSuperset
extends Operator {
    private InputPort exampleSet1Input = this.getInputPorts().createPort("example set 1", ExampleSet.class);
    private InputPort exampleSet2Input = this.getInputPorts().createPort("example set 2", ExampleSet.class);
    private OutputPort supersetOutput1 = (OutputPort)this.getOutputPorts().createPort("superset 1");
    private OutputPort supersetOutput2 = (OutputPort)this.getOutputPorts().createPort("superset 2");

    public ExampleSetSuperset(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetUnionRule(this.exampleSet1Input, this.exampleSet2Input, this.supersetOutput1, null){

            @Override
            protected void transformAddedAttributeMD(ExampleSetMetaData emd, AttributeMetaData newAttribute) {
                newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
                newAttribute.setNumberOfMissingValues(emd.getNumberOfExamples());
            }
        });
        this.getTransformer().addRule(new ExampleSetUnionRule(this.exampleSet2Input, this.exampleSet1Input, this.supersetOutput2, null){

            @Override
            protected void transformAddedAttributeMD(ExampleSetMetaData emd, AttributeMetaData newAttribute) {
                newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
                newAttribute.setNumberOfMissingValues(emd.getNumberOfExamples());
            }
        });
    }

    public void superset(ExampleSet exampleSet1, ExampleSet exampleSet2) {
        LinkedList<Attribute> newAttributesForES1 = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet2.getAttributes()) {
            if (exampleSet1.getAttributes().get(attribute.getName()) != null) continue;
            newAttributesForES1.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
        }
        LinkedList<Attribute> newAttributesForES2 = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet1.getAttributes()) {
            if (exampleSet2.getAttributes().get(attribute.getName()) != null) continue;
            newAttributesForES2.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
        }
        for (Attribute attribute : newAttributesForES1) {
            exampleSet1.getExampleTable().addAttribute(attribute);
            exampleSet1.getAttributes().addRegular(attribute);
        }
        for (Attribute attribute : newAttributesForES2) {
            exampleSet2.getExampleTable().addAttribute(attribute);
            exampleSet2.getAttributes().addRegular(attribute);
        }
        for (Example example : exampleSet1) {
            for (Attribute attribute : newAttributesForES1) {
                example.setValue(attribute, Double.NaN);
            }
        }
        for (Example example : exampleSet2) {
            for (Attribute attribute : newAttributesForES2) {
                example.setValue(attribute, Double.NaN);
            }
        }
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet1 = (ExampleSet)this.exampleSet1Input.getData();
        ExampleSet exampleSet2 = (ExampleSet)this.exampleSet2Input.getData();
        this.superset(exampleSet1, exampleSet2);
        this.supersetOutput1.deliver(exampleSet1);
        this.supersetOutput2.deliver(exampleSet2);
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), ExampleSetSuperset.class, null);
    }
}

